/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Password;
import org.dspace.app.xmlui.wing.element.Text;
import org.xml.sax.SAXException;

public class LDAPLogin
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    public static final Message T_title = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.title");
    public static final Message T_dspace_home = LDAPLogin.message((String)"xmlui.general.dspace_home");
    public static final Message T_trail = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.trail");
    public static final Message T_head1 = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.head1");
    public static final Message T_userName = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.username");
    public static final Message T_error_bad_login = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.error_bad_login");
    public static final Message T_password = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.password");
    public static final Message T_submit = LDAPLogin.message((String)"xmlui.EPerson.LDAPLogin.submit");

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String previous_username = request.getParameter("username");
        HttpSession session = request.getSession();
        String header = (String)session.getAttribute("dspace.request.interrupted.header");
        String message = (String)session.getAttribute("dspace.request.interrupted.message");
        String characters = (String)session.getAttribute("dspace.request.interrupted.characters");
        if (header == null && message == null && characters == null && previous_username == null) {
            return "1";
        }
        return "0";
    }

    public SourceValidity getValidity() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String previous_username = request.getParameter("username");
        HttpSession session = request.getSession();
        String header = (String)session.getAttribute("dspace.request.interrupted.header");
        String message = (String)session.getAttribute("dspace.request.interrupted.message");
        String characters = (String)session.getAttribute("dspace.request.interrupted.characters");
        if (header == null && message == null && characters == null && previous_username == null) {
            return NOPValidity.SHARED_INSTANCE;
        }
        return null;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SQLException, SAXException, WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        HttpSession session = request.getSession();
        String previousUserName = request.getParameter("username");
        String header = (String)session.getAttribute("dspace.request.interrupted.header");
        String message = (String)session.getAttribute("dspace.request.interrupted.message");
        String characters = (String)session.getAttribute("dspace.request.interrupted.characters");
        if (header != null || message != null || characters != null) {
            Division reason = body.addDivision("login-reason");
            if (header != null) {
                reason.setHead(LDAPLogin.message((String)header));
            } else {
                reason.setHead("Authentication Required");
            }
            if (message != null) {
                reason.addPara(LDAPLogin.message((String)message));
            }
            if (characters != null) {
                reason.addPara(characters);
            }
        }
        Division login = body.addInteractiveDivision("login", this.contextPath + "/ldap-login", "post", "primary");
        login.setHead(T_head1);
        List list = login.addList("ldap-login", "form");
        Text email = list.addItem().addText("username");
        email.setRequired();
        email.setLabel(T_userName);
        if (previousUserName != null) {
            email.setValue(previousUserName);
            email.addError(T_error_bad_login);
        }
        Item item = list.addItem();
        Password password = item.addPassword("ldap_password");
        password.setRequired();
        password.setLabel(T_password);
        list.addLabel();
        Item submit = list.addItem("login-in", null);
        submit.addButton("submit").setValue(T_submit);
    }
}

