/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.selection.Selector;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;

public class IfModifiedSinceSelector
implements Selector {
    private static Logger log = Logger.getLogger(IfModifiedSinceSelector.class);

    public boolean select(String expression, Map objectModel, Parameters parameters) {
        try {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            DSpaceObject dso = HandleUtil.obtainHandle(objectModel);
            if (dso.getType() == 2) {
                Item item = (Item)dso;
                long modSince = request.getDateHeader("If-Modified-Since");
                if (modSince != -1L && item.getLastModified().getTime() < modSince) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Error selecting based on If-Modified-Since: " + e.toString()));
            return false;
        }
    }
}

