/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.configuration.Aspect;
import org.dspace.app.xmlui.configuration.Theme;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class XMLUIConfiguration {
    private static Logger log = Logger.getLogger(XMLUIConfiguration.class);
    private static List<Aspect> aspects = new ArrayList<Aspect>();
    private static List<Theme> themes = new ArrayList<Theme>();

    public static void loadConfig(String ... configPaths) throws IOException, JDOMException {
        if (configPaths == null || configPaths.length == 0) {
            throw new IllegalStateException("The xmlui configuration path must be defined.");
        }
        File configFile = null;
        for (String configPath : configPaths) {
            if (configPath != null) {
                configFile = new File(configPath);
            }
            if (configFile != null && configFile.exists() && configFile.canRead()) {
                log.info((Object)("Loading XMLUI configuration from: " + configPath));
                break;
            }
            log.debug((Object)("Faild to load XMLUI configuration from: " + configPath));
        }
        if (configFile == null) {
            StringBuilder allPaths = new StringBuilder();
            for (String configPath : configPaths) {
                if (allPaths.length() > 0) {
                    allPaths.append(", ");
                }
                allPaths.append(configPath);
            }
            throw new IllegalStateException("None of the xmlui configuration paths were valid: " + allPaths);
        }
        SAXBuilder builder = new SAXBuilder();
        Document config = builder.build(configFile);
        List aspectElements = XPath.selectNodes((Object)config, (String)"//xmlui/aspects/aspect");
        List themeElements = XPath.selectNodes((Object)config, (String)"//xmlui/themes/theme");
        for (Element aspectElement : aspectElements) {
            String path = aspectElement.getAttributeValue("path");
            String name = aspectElement.getAttributeValue("name");
            if (path == null || path.length() == 0) {
                throw new IllegalStateException("All aspects muth define a path");
            }
            aspects.add(new Aspect(name, path));
            log.info((Object)("Aspect Installed: name='" + name + "', path='" + path + "'."));
        }
        Collections.reverse(aspects);
        for (Element themeElement : themeElements) {
            String name = themeElement.getAttributeValue("name");
            String path = themeElement.getAttributeValue("path");
            String id = themeElement.getAttributeValue("id");
            String regex = themeElement.getAttributeValue("regex");
            String handle = themeElement.getAttributeValue("handle");
            if (path == null || path.length() == 0) {
                throw new IllegalStateException("All themes muth define a path");
            }
            themes.add(new Theme(name, path, id, regex, handle));
            log.info((Object)("Theme Installed: name='" + name + "', path='" + path + "', id='" + id + "', regex='" + regex + "', handle='" + handle + "'."));
        }
    }

    public static List<Aspect> getAspectChain() {
        return aspects;
    }

    public static List<Theme> getThemeRules() {
        return themes;
    }
}

