/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.hdfs;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.common.blobstore.AppendableBlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.hdfs.AbstractHdfsBlobContainer;
import org.elasticsearch.common.blobstore.hdfs.HdfsBlobStore;
import org.elasticsearch.common.io.stream.DataOutputStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class HdfsAppendableBlobContainer
extends AbstractHdfsBlobContainer
implements AppendableBlobContainer {
    public HdfsAppendableBlobContainer(HdfsBlobStore blobStore, BlobPath blobPath, Path path) {
        super(blobStore, blobPath, path);
    }

    public AppendableBlobContainer.AppendableBlob appendBlob(String blobName) throws IOException {
        return new HdfsAppendableBlob(new Path(this.path, blobName));
    }

    private class HdfsAppendableBlob
    implements AppendableBlobContainer.AppendableBlob {
        private final Path file;
        private final FSDataOutputStream fsDataStream;
        private final DataOutputStreamOutput out;

        public HdfsAppendableBlob(Path file) throws IOException {
            this.file = file;
            this.fsDataStream = HdfsAppendableBlobContainer.this.blobStore.fileSystem().create(file, true);
            this.out = new DataOutputStreamOutput((DataOutput)this.fsDataStream);
        }

        public void append(final AppendableBlobContainer.AppendBlobListener listener) {
            HdfsAppendableBlobContainer.this.blobStore.executor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.withStream((StreamOutput)HdfsAppendableBlob.this.out);
                        HdfsAppendableBlob.this.out.flush();
                        HdfsAppendableBlob.this.fsDataStream.flush();
                        HdfsAppendableBlob.this.fsDataStream.sync();
                        listener.onCompleted();
                    }
                    catch (IOException e) {
                        listener.onFailure((Throwable)e);
                    }
                }
            });
        }

        public void close() {
            try {
                this.fsDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

