/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.cascading.EsLocalScheme;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.QueryBuilder;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.builder.JdkValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.util.StringUtils;

class EsLocalTap
extends Tap<Properties, ScrollQuery, Object> {
    private static final long serialVersionUID = 8644631529427137615L;
    private static Log log = LogFactory.getLog(EsLocalTap.class);
    private final String target;
    private final Properties tapProperties;

    public EsLocalTap(String host, int port, String resource, String query, Fields fields, Properties props) {
        super((Scheme)new EsLocalScheme(host, port, resource, query, fields, props), SinkMode.UPDATE);
        this.target = resource;
        this.tapProperties = props;
    }

    public String getIdentifier() {
        return this.target;
    }

    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, ScrollQuery input) throws IOException {
        if (input == null) {
            Settings settings = CascadingUtils.addDefaultsToSettings(CascadingUtils.extractOriginalProperties((Properties)flowProcess.getConfigCopy()), this.tapProperties, log);
            RestRepository client = new RestRepository(settings);
            Field mapping = client.getMapping();
            Collection<String> fields = CascadingUtils.fieldToAlias(settings, this.getSourceFields());
            FieldPresenceValidation validation = settings.getFieldExistanceValidation();
            if (validation.isRequired()) {
                MappingUtils.validateMapping(fields, mapping, validation, log);
            }
            input = QueryBuilder.query(settings).fields(StringUtils.concatenateAndUriEncode(fields, ",")).build(client, new ScrollReader(new JdkValueReader(), mapping));
        }
        return new TupleEntrySchemeIterator(flowProcess, this.getScheme(), (Object)input, this.getIdentifier());
    }

    public TupleEntryCollector openForWrite(FlowProcess<Properties> flowProcess, Object output) throws IOException {
        return new TupleEntrySchemeCollector(flowProcess, this.getScheme(), output);
    }

    public boolean createResource(Properties conf) throws IOException {
        return false;
    }

    public boolean deleteResource(Properties conf) throws IOException {
        return false;
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return true;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return -1L;
    }
}

