/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommands;
import org.elasticsearch.hadoop.serialization.dto.Node;
import org.elasticsearch.hadoop.serialization.dto.Shard;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestRepository
implements Closeable,
StatsAware {
    private static Log log = LogFactory.getLog(RestRepository.class);
    private int bufferEntriesThreshold;
    private final BytesArray ba = new BytesArray(0);
    private final TrackingBytesArray data = new TrackingBytesArray(this.ba);
    private int dataEntries = 0;
    private boolean requiresRefreshAfterBulk = false;
    private boolean executedBulkWrite = false;
    private BytesRef trivialBytesRef;
    private boolean writeInitialized = false;
    private boolean hadWriteErrors = false;
    private RestClient client;
    private Resource resourceR;
    private Resource resourceW;
    private BulkCommand command;
    private final Settings settings;
    private final Stats stats = new Stats();

    public RestRepository(Settings settings) {
        this.settings = settings;
        if (StringUtils.hasText(settings.getResourceRead())) {
            this.resourceR = new Resource(settings, true);
        }
        if (StringUtils.hasText(settings.getResourceWrite())) {
            this.resourceW = new Resource(settings, false);
        }
        Assert.isTrue(this.resourceR != null || this.resourceW != null, "Invalid configuration - No read or write resource specified");
        this.client = new RestClient(settings);
    }

    private void lazyInitWriting() {
        if (!this.writeInitialized) {
            this.writeInitialized = true;
            this.ba.bytes(new byte[this.settings.getBatchSizeInBytes()], 0);
            this.trivialBytesRef = new BytesRef();
            this.bufferEntriesThreshold = this.settings.getBatchSizeInEntries();
            this.requiresRefreshAfterBulk = this.settings.getBatchRefreshAfterWrite();
            this.command = BulkCommands.create(this.settings);
        }
    }

    ScrollQuery scan(String query, BytesArray body, ScrollReader reader) {
        String[] scrollInfo = this.client.scan(query, body);
        String scrollId = scrollInfo[0];
        long totalSize = Long.parseLong(scrollInfo[1]);
        return new ScrollQuery(this, scrollId, totalSize, reader);
    }

    public void writeToIndex(Object object) throws IOException {
        Assert.notNull(object, "no object data given");
        this.lazyInitWriting();
        this.doWriteToIndex(this.command.write(object));
    }

    public void writeProcessedToIndex(BytesArray ba) {
        Assert.notNull(ba, "no data given");
        Assert.isTrue(ba.length() > 0, "no data given");
        this.lazyInitWriting();
        this.trivialBytesRef.reset();
        this.trivialBytesRef.add(ba);
        this.doWriteToIndex(this.trivialBytesRef);
    }

    private void doWriteToIndex(BytesRef payload) {
        if (payload.length() > this.ba.available()) {
            this.sendBatch();
        }
        this.data.copyFrom(payload);
        payload.reset();
        ++this.dataEntries;
        if (this.bufferEntriesThreshold > 0 && this.dataEntries >= this.bufferEntriesThreshold) {
            this.sendBatch();
        }
    }

    private void sendBatch() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending batch of [%d] bytes/[%s] entries", this.data.length(), this.dataEntries));
        }
        try {
            this.client.bulk(this.resourceW, this.data);
        }
        catch (EsHadoopException ex) {
            this.hadWriteErrors = true;
            throw ex;
        }
        this.data.reset();
        this.dataEntries = 0;
        this.executedBulkWrite = true;
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing repository and connection to Elasticsearch ...");
        }
        if (this.data.length() > 0) {
            if (!this.hadWriteErrors) {
                this.sendBatch();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Dirty close; ignoring last existing write batch...");
            }
        }
        if (this.requiresRefreshAfterBulk && this.executedBulkWrite) {
            this.client.refresh(this.resourceW);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Refreshing index [%s]", this.resourceW));
            }
        }
        if (this.client != null) {
            this.client.close();
            this.stats.aggregate(this.client.stats());
            this.client = null;
        }
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public Map<Shard, Node> getReadTargetShards() {
        Map<String, Node> nodes = this.client.getNodes();
        LinkedHashMap<Shard, Node> shards = new LinkedHashMap<Shard, Node>();
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resourceR.index());
        block0: for (List<Map<String, Object>> shardGroup : info) {
            for (Map<String, Object> shardData : shardGroup) {
                Shard shard = new Shard(shardData);
                if (!shard.getState().isStarted()) continue;
                Node node = nodes.get(shard.getNode());
                Assert.notNull(node, "Cannot find node with id [" + shard.getNode() + "]");
                shards.put(shard, node);
                continue block0;
            }
        }
        return shards;
    }

    public Map<Shard, Node> getWriteTargetPrimaryShards() throws IOException {
        Map<String, Node> nodes = this.client.getNodes();
        List<List<Map<String, Object>>> info = this.client.targetShards(this.resourceW.index());
        LinkedHashMap<Shard, Node> shards = new LinkedHashMap<Shard, Node>(info.size());
        block0: for (List<Map<String, Object>> shardGroup : info) {
            for (Map<String, Object> shardData : shardGroup) {
                Shard shard = new Shard(shardData);
                if (!shard.isPrimary()) continue;
                Node node = nodes.get(shard.getNode());
                Assert.notNull(node, "Cannot find node with id [" + shard.getNode() + "]");
                shards.put(shard, node);
                continue block0;
            }
        }
        return shards;
    }

    public Field getMapping() throws IOException {
        return Field.parseField(this.client.getMapping(this.resourceR.mapping()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> scroll(String scrollId, ScrollReader reader) throws IOException {
        InputStream scroll = this.client.scroll(scrollId);
        try {
            List<Object[]> list = reader.read(scroll);
            return list;
        }
        finally {
            if (scroll instanceof StatsAware) {
                this.stats.aggregate(((StatsAware)((Object)scroll)).stats());
            }
        }
    }

    public boolean indexExists(boolean read) throws IOException {
        Resource res = read ? this.resourceR : this.resourceW;
        boolean exists = this.client.exists(res.indexAndType());
        if (!exists && read) {
            try {
                exists = !this.client.getMapping(res.mapping()).isEmpty();
            }
            catch (EsHadoopInvalidRequest ex) {
                exists = false;
            }
        }
        return exists;
    }

    public void putMapping(BytesArray mapping) throws IOException {
        this.client.putMapping(this.resourceW.index(), this.resourceW.mapping(), mapping.bytes());
    }

    public boolean touch() throws IOException {
        return this.client.touch(this.resourceW.index());
    }

    public boolean waitForYellow() throws IOException {
        return this.client.health(this.resourceW.index(), RestClient.HEALTH.YELLOW, TimeValue.timeValueSeconds(10L));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.client != null) {
            copy.aggregate(this.client.stats());
        }
        return copy;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

