/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.field.FieldExplainer;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.serialization.field.WithoutQuotes;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class AbstractDefaultParamsExtractor
implements FieldExtractor,
SettingsAware,
FieldExplainer,
WithoutQuotes {
    private Map<String, FieldExtractor> params = new LinkedHashMap<String, FieldExtractor>();
    protected Settings settings;
    private FieldExtractor lastFailingFieldExtractor;

    @Override
    public Object field(Object target) {
        ArrayList<Object> list = new ArrayList<Object>(this.params.size());
        for (Map.Entry<String, FieldExtractor> entry : this.params.entrySet()) {
            list.add("\"");
            list.add(entry.getKey());
            list.add("\":");
            Object field = entry.getValue().field(target);
            if (field == FieldExtractor.NOT_FOUND) {
                this.lastFailingFieldExtractor = entry.getValue();
                return FieldExtractor.NOT_FOUND;
            }
            list.add(field);
            list.add(",");
        }
        list.remove(list.size() - 1);
        return list;
    }

    @Override
    public String toString(Object target) {
        return this.lastFailingFieldExtractor instanceof FieldExplainer ? ((FieldExplainer)((Object)this.lastFailingFieldExtractor)).toString(target) : target.toString();
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
        String paramString = settings.getUpdateScriptParams();
        List<String> fields = StringUtils.tokenize(paramString);
        for (String string : fields) {
            List<String> param = StringUtils.tokenize(string, ":");
            Assert.isTrue(param.size() == 2, "Invalid param definition " + string);
            this.params.put(param.get(0), this.createFieldExtractor(param.get(1)));
        }
    }

    public String toString() {
        if (this.lastFailingFieldExtractor != null) {
            return this.lastFailingFieldExtractor.toString();
        }
        return String.format("%s for fields [%s]", this.getClass().getSimpleName(), this.params.keySet());
    }

    protected abstract FieldExtractor createFieldExtractor(String var1);
}

