/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MultiOutputFormat
extends OutputFormat {
    public static final String CFG_FIELD = "es.hadoop.multi.of";
    private transient List<OutputFormat> formats = null;

    public RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        List<OutputFormat> formats = this.getFormats(context.getConfiguration());
        ArrayList<RecordWriter> writers = new ArrayList<RecordWriter>();
        for (OutputFormat format : formats) {
            writers.add(format.getRecordWriter(context));
        }
        return new MultiRecordWriter(writers);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        List<OutputFormat> formats = this.getFormats(context.getConfiguration());
        for (OutputFormat format : formats) {
            format.checkOutputSpecs(context);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        List<OutputFormat> formats = this.getFormats(context.getConfiguration());
        ArrayList<OutputCommitter> committers = new ArrayList<OutputCommitter>();
        for (OutputFormat format : formats) {
            committers.add(format.getOutputCommitter(context));
        }
        return new MultiOutputCommitter(committers);
    }

    public static void addOutputFormat(Configuration cfg, Class<? extends OutputFormat> ... formats) {
        Collection of = cfg.getStringCollection(CFG_FIELD);
        for (Class<? extends OutputFormat> format : formats) {
            of.add(format.getName());
        }
        cfg.setStrings(CFG_FIELD, new String[]{StringUtils.join((Collection)of, (String)",")});
    }

    private List<OutputFormat> getFormats(Configuration cfg) {
        if (this.formats == null) {
            this.formats = cfg.getInstances(CFG_FIELD, OutputFormat.class);
        }
        return this.formats;
    }

    private static class MultiOutputCommitter
    extends OutputCommitter {
        private final List<OutputCommitter> committers;

        MultiOutputCommitter(List<OutputCommitter> committers) {
            this.committers = committers;
        }

        public void setupJob(JobContext jobContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.setupJob(jobContext);
            }
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.setupTask(taskContext);
            }
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            boolean result = false;
            for (OutputCommitter committer : this.committers) {
                result |= committer.needsTaskCommit(taskContext);
            }
            return result;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.commitTask(taskContext);
            }
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.abortTask(taskContext);
            }
        }
    }

    private static class MultiRecordWriter
    extends RecordWriter {
        private final List<RecordWriter> writers;

        public MultiRecordWriter(List<RecordWriter> writers) {
            this.writers = writers;
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            for (RecordWriter writer : this.writers) {
                writer.write(key, value);
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            for (RecordWriter writer : this.writers) {
                writer.close(context);
            }
        }
    }
}

