/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

public class PigBytesConverter
extends JdkBytesConverter {
    @Override
    public void convert(Object from, BytesArray to) {
        byte type;
        Object object;
        Assert.isTrue(from instanceof PigTuple, String.format("Unexpected object type, expecting [%s], given [%s]", PigTuple.class, from.getClass()));
        PigTuple pt = (PigTuple)from;
        ResourceSchema.ResourceFieldSchema schema = pt.getSchema();
        ResourceSchema tupleSchema = schema.getSchema();
        if (tupleSchema == null) {
            to.bytes("{}");
            return;
        }
        ResourceSchema.ResourceFieldSchema[] fields = tupleSchema.getFields();
        Assert.isTrue(fields.length == 1, "When using JSON input, only one field is expected");
        try {
            object = pt.getTuple().get(0);
            type = pt.getTuple().getType(0);
        }
        catch (Exception ex) {
            throw new EsHadoopIllegalStateException("Encountered exception while processing tuple", ex);
        }
        if (type == 60 || type == 55) {
            to.bytes(object.toString());
            return;
        }
        if (type == 50) {
            DataByteArray dba = (DataByteArray)object;
            to.bytes(dba.get(), dba.size());
            return;
        }
        throw new EsHadoopIllegalArgumentException(String.format("Cannot handle Pig type [%s]; expecting [%s,%s]", object.getClass(), String.class, DataByteArray.class));
    }
}

