/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ContentBuilder;
import org.elasticsearch.hadoop.serialization.builder.NoOpValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class InitializationUtils {
    public static void checkIdForOperation(Settings settings) {
        String operation = settings.getOperation();
        if ("update".equals(operation)) {
            Assert.isTrue(StringUtils.hasText(settings.getMappingId()), String.format("Operation [%s] requires an id but none (%s) was specified", operation, "es.mapping.id"));
        }
    }

    public static boolean discoverNodesIfNeeded(Settings settings, Log log) throws IOException {
        if (settings.getNodesDiscovery()) {
            RestClient bootstrap = new RestClient(settings);
            List<String> discoveredNodes = bootstrap.discoverNodes();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Nodes discovery enabled - found %s", discoveredNodes));
            }
            bootstrap.close();
            SettingsUtils.addDiscoveredNodes(settings, discoveredNodes);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String discoverEsVersion(Settings settings, Log log) throws IOException {
        String version = settings.getProperty("es.internal.es.version");
        if (StringUtils.hasText(version)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Elasticsearch version [%s] already present in configuration; skipping discovery", version));
            }
            return version;
        }
        RestClient bootstrap = new RestClient(settings);
        try {
            String esVersion = bootstrap.esVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Discovered Elasticsearch version [%s]", esVersion));
            }
            settings.setProperty("es.internal.es.version", esVersion);
            String string = esVersion;
            return string;
        }
        finally {
            bootstrap.close();
        }
    }

    public static void checkIndexExistence(RestRepository client) {
        InitializationUtils.checkIndexExistence(client.getSettings(), client);
    }

    public static void checkIndexExistence(Settings settings, RestRepository client) {
        if (!settings.getIndexAutoCreate()) {
            if (client == null) {
                client = new RestRepository(settings);
            }
            try {
                if (!client.indexExists(false)) {
                    client.close();
                    throw new EsHadoopIllegalArgumentException(String.format("Target index [%s] does not exist and auto-creation is disabled [setting '%s' is '%s']", settings.getResourceWrite(), "es.index.auto.create", settings.getIndexAutoCreate()));
                }
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException("Cannot check index existance", ex);
            }
        }
    }

    public static boolean setFieldExtractorIfNotSet(Settings settings, Class<? extends FieldExtractor> clazz, Log log) {
        if (!StringUtils.hasText(settings.getMappingIdExtractorClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            settings.setProperty("es.mapping.default.extractor.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined field extractor [%s] as default", settings.getMappingIdExtractorClassName()));
            }
            return true;
        }
        return false;
    }

    public static <T> void saveSchemaIfNeeded(Object conf, ValueWriter<T> schemaWriter, T schema, Log log) throws IOException {
        Settings settings = SettingsManager.loadFrom(conf);
        if (settings.getIndexAutoCreate()) {
            RestRepository client = new RestRepository(settings);
            if (!client.indexExists(false)) {
                if (schemaWriter == null) {
                    log.warn((Object)String.format("No mapping found [%s] and no schema found; letting Elasticsearch perform auto-mapping...", settings.getResourceWrite()));
                } else {
                    log.info((Object)String.format("No mapping found [%s], creating one based on given schema", settings.getResourceWrite()));
                    ContentBuilder builder = ContentBuilder.generate(schemaWriter).value(schema).flush();
                    BytesArray content = ((FastByteArrayOutputStream)builder.content()).bytes();
                    builder.close();
                    client.putMapping(content);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Creating ES mapping [%s] from schema [%s]", content.toString(), schema));
                    }
                }
            }
            client.close();
        }
    }

    public static boolean setValueWriterIfNotSet(Settings settings, Class<? extends ValueWriter<?>> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueWriterClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            if (settings.getInputAsJson()) {
                name = NoOpValueWriter.class.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Elasticsearch input marked as JSON; bypassing serialization through [%s] instead of [%s]", name, clazz));
                }
            }
            settings.setProperty("es.ser.writer.value.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined writer serializer [%s] as default", settings.getSerializerValueWriterClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setBytesConverterIfNeeded(Settings settings, Class<? extends BytesConverter> clazz, Log log) {
        if (settings.getInputAsJson() && !StringUtils.hasText(settings.getSerializerBytesConverterClassName())) {
            Log logger;
            settings.setProperty("es.ser.writer.bytes.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("JSON input specified; using pre-defined bytes/json converter [%s] as default", settings.getSerializerBytesConverterClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setValueReaderIfNotSet(Settings settings, Class<? extends ValueReader> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueReaderClassName())) {
            Log logger;
            settings.setProperty("es.ser.reader.value.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined reader serializer [%s] as default", settings.getSerializerValueReaderClassName()));
            }
            return true;
        }
        return false;
    }
}

