/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.DelegatingInputStream;
import org.elasticsearch.hadoop.rest.EsHadoopTransportException;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.ReusableInputStream;
import org.elasticsearch.hadoop.rest.SimpleResponse;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.commonshttp.BytesArrayRequestEntity;
import org.elasticsearch.hadoop.rest.commonshttp.ProtocolAwareHostConfiguration;
import org.elasticsearch.hadoop.rest.commonshttp.SocksProtocol;
import org.elasticsearch.hadoop.rest.commonshttp.SocksSocketFactory;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.ReflectionUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class CommonsHttpTransport
implements Transport,
StatsAware {
    private static Log log = LogFactory.getLog(CommonsHttpTransport.class);
    private static final Method GET_SOCKET = ReflectionUtils.findMethod(HttpConnection.class, "getSocket", null);
    private final HttpClient client;
    private final Stats stats = new Stats();
    private HttpConnection conn;
    private String proxyInfo = "";
    private final String httpInfo;

    public CommonsHttpTransport(Settings settings, String host) {
        this.httpInfo = host;
        HttpClientParams params = new HttpClientParams();
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(settings.getHttpRetries(), false){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                if (super.retryMethod(method, exception, executionCount)) {
                    ++((CommonsHttpTransport)CommonsHttpTransport.this).stats.netRetries;
                    return true;
                }
                return false;
            }
        });
        params.setConnectionManagerTimeout(settings.getHttpTimeout());
        params.setSoTimeout((int)settings.getHttpTimeout());
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig = this.setupSocksProxy(settings, hostConfig);
        Object[] httpProxySettings = this.setupHttpProxy(settings, hostConfig);
        hostConfig = (HostConfiguration)httpProxySettings[0];
        try {
            hostConfig.setHost(new URI(CommonsHttpTransport.escapeUri(host), false));
        }
        catch (IOException ex) {
            throw new EsHadoopTransportException("Invalid target URI " + host, ex);
        }
        this.client = new HttpClient(params, (HttpConnectionManager)new SocketTrackingConnectionManager());
        this.client.setHostConfiguration(hostConfig);
        this.completeHttpProxyInit(httpProxySettings);
        HttpConnectionManagerParams connectionParams = this.client.getHttpConnectionManager().getParams();
        connectionParams.setTcpNoDelay(true);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Opening HTTP transport to " + this.httpInfo));
        }
    }

    private void completeHttpProxyInit(Object[] httpProxySettings) {
        if (httpProxySettings[1] != null) {
            this.client.setState((HttpState)httpProxySettings[1]);
            this.client.getParams().setAuthenticationPreemptive(true);
        }
    }

    private Object[] setupHttpProxy(Settings settings, HostConfiguration hostConfig) {
        Object[] results = new Object[2];
        results[0] = hostConfig;
        String proxyHost = null;
        int proxyPort = -1;
        if (settings.getNetworkHttpUseSystemProperties()) {
            proxyHost = System.getProperty("http.proxyHost");
            proxyPort = Integer.getInteger("http.proxyPort", -1);
        }
        if (StringUtils.hasText(settings.getNetworkProxyHttpHost())) {
            proxyHost = settings.getNetworkProxyHttpHost();
        }
        if (settings.getNetworkProxyHttpPort() > 0) {
            proxyPort = settings.getNetworkProxyHttpPort();
        }
        if (StringUtils.hasText(proxyHost)) {
            hostConfig.setProxy(proxyHost, proxyPort);
            this.proxyInfo = this.proxyInfo.concat(String.format("[HTTP proxy %s:%s]", proxyHost, proxyPort));
            if (StringUtils.hasText(settings.getNetworkProxyHttpUser())) {
                if (!StringUtils.hasText(settings.getNetworkProxyHttpPass())) {
                    log.warn((Object)String.format("HTTP proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.http.pass"));
                }
                HttpState state = new HttpState();
                state.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.getNetworkProxyHttpUser(), settings.getNetworkProxyHttpPass()));
                state.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.getNetworkProxyHttpUser(), settings.getNetworkProxyHttpPass()));
                results[1] = state;
            }
            if (log.isDebugEnabled()) {
                if (StringUtils.hasText(settings.getNetworkProxyHttpUser())) {
                    log.debug((Object)String.format("Using authenticated HTTP proxy [%s:%s]", proxyHost, proxyPort));
                } else {
                    log.debug((Object)String.format("Using HTTP proxy [%s:%s]", proxyHost, proxyPort));
                }
            }
        }
        return results;
    }

    private HostConfiguration setupSocksProxy(Settings settings, HostConfiguration hostConfig) {
        String proxyHost = null;
        int proxyPort = -1;
        String proxyUser = null;
        String proxyPass = null;
        if (settings.getNetworkHttpUseSystemProperties()) {
            proxyHost = System.getProperty("socksProxyHost");
            proxyPort = Integer.getInteger("socksProxyPort", -1);
            proxyUser = System.getProperty("java.net.socks.username");
            proxyPass = System.getProperty("java.net.socks.password");
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksHost())) {
            proxyHost = settings.getNetworkProxySocksHost();
        }
        if (settings.getNetworkProxySocksPort() > 0) {
            proxyPort = settings.getNetworkProxySocksPort();
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksUser())) {
            proxyUser = settings.getNetworkProxySocksUser();
        }
        if (StringUtils.hasText(settings.getNetworkProxySocksPass())) {
            proxyPass = settings.getNetworkProxySocksPass();
        }
        if (StringUtils.hasText(proxyHost)) {
            this.proxyInfo = this.proxyInfo.concat(String.format("[SOCKS proxy %s:%s]", proxyHost, proxyPort));
            if (!StringUtils.hasText(proxyUser)) {
                log.warn((Object)String.format("SOCKS proxy user specified but no/empty password defined - double check the [%s] property", "es.net.proxy.socks.pass"));
            }
            if (log.isDebugEnabled()) {
                if (StringUtils.hasText(proxyUser)) {
                    log.debug((Object)String.format("Using authenticated SOCKS proxy [%s:%s]", proxyHost, proxyPort));
                } else {
                    log.debug((Object)String.format("Using SOCKS proxy [%s:%s]", proxyHost, proxyPort));
                }
            }
            hostConfig = new ProtocolAwareHostConfiguration(hostConfig);
            SocksSocketFactory socksSocksFactory = new SocksSocketFactory(proxyHost, proxyPort, proxyUser, proxyPass);
            Protocol directHttp = Protocol.getProtocol((String)"http");
            SocksProtocol proxiedHttp = new SocksProtocol(socksSocksFactory, directHttp);
            hostConfig.setHost(proxyHost, proxyPort, (Protocol)proxiedHttp);
            Protocol.registerProtocol((String)"http", (Protocol)proxiedHttp);
        }
        return hostConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute(Request request) throws IOException {
        ByteSequence ba;
        DeleteMethod http = null;
        switch (request.method()) {
            case DELETE: {
                http = new DeleteMethod();
                break;
            }
            case HEAD: {
                http = new HeadMethod();
                break;
            }
            case GET: {
                http = new GetMethod();
                break;
            }
            case POST: {
                http = new PostMethod();
                break;
            }
            case PUT: {
                http = new PutMethod();
                break;
            }
            default: {
                throw new EsHadoopTransportException("Unknown request method " + (Object)((Object)request.method()));
            }
        }
        CharSequence uri = request.uri();
        if (StringUtils.hasText(uri)) {
            http.setURI(new URI(CommonsHttpTransport.escapeUri(uri.toString()), false));
        }
        http.setPath(CommonsHttpTransport.prefixPath(request.path().toString()));
        try {
            uri = http.getURI().toString();
        }
        catch (URIException uriex) {
            throw new EsHadoopTransportException("Invalid target URI " + request, uriex);
        }
        CharSequence params = request.params();
        if (StringUtils.hasText(params)) {
            http.setQueryString(params.toString());
        }
        if ((ba = request.body()) != null && ba.length() > 0) {
            EntityEnclosingMethod entityMethod = (EntityEnclosingMethod)http;
            entityMethod.setRequestEntity((RequestEntity)new BytesArrayRequestEntity(ba));
            entityMethod.setContentChunked(false);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Tx %s[%s]@[%s][%s] w/ payload [%s]", this.proxyInfo, request.method().name(), this.httpInfo, request.path(), request.body()));
        }
        long start = System.currentTimeMillis();
        try {
            this.client.executeMethod((HttpMethod)http);
        }
        finally {
            this.stats.netTotalTime += System.currentTimeMillis() - start;
        }
        if (log.isTraceEnabled()) {
            Socket sk = (Socket)ReflectionUtils.invoke(GET_SOCKET, this.conn, null);
            String addr = sk.getLocalAddress().getHostAddress();
            log.trace((Object)String.format("Rx %s@[%s] [%s-%s] [%s]", this.proxyInfo, addr, http.getStatusCode(), HttpStatus.getStatusText((int)http.getStatusCode()), http.getResponseBodyAsString()));
        }
        return new SimpleResponse(http.getStatusCode(), new ResponseInputStream((HttpMethod)http), request.uri());
    }

    @Override
    public void close() {
        HttpConnectionManager manager;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Closing HTTP transport to " + this.httpInfo));
        }
        if ((manager = this.client.getHttpConnectionManager()) instanceof SimpleHttpConnectionManager) {
            try {
                ((SimpleHttpConnectionManager)manager).closeIdleConnections(0L);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception ex) {
                log.warn((Object)"Exception closing underlying HTTP manager", (Throwable)ex);
            }
        }
    }

    private static String escapeUri(String uri) {
        String escaped = StringUtils.encodeUri(uri);
        return escaped.contains("://") ? escaped : "http://" + escaped;
    }

    private static String prefixPath(String string) {
        return string.startsWith("/") ? string : "/" + string;
    }

    @Override
    public Stats stats() {
        return this.stats;
    }

    static {
        ReflectionUtils.makeAccessible(GET_SOCKET);
    }

    private class SocketTrackingConnectionManager
    extends SimpleHttpConnectionManager {
        private SocketTrackingConnectionManager() {
        }

        public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
            CommonsHttpTransport.this.conn = super.getConnectionWithTimeout(hostConfiguration, timeout);
            return CommonsHttpTransport.this.conn;
        }
    }

    private static class ResponseInputStream
    extends DelegatingInputStream
    implements ReusableInputStream {
        private final HttpMethod method;
        private final boolean reusable;

        public ResponseInputStream(HttpMethod http) throws IOException {
            super(http.getResponseBodyAsStream());
            this.method = http;
            this.reusable = this.delegate() instanceof ByteArrayInputStream;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public InputStream copy() {
            try {
                return this.reusable ? this.method.getResponseBodyAsStream() : null;
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.isNull()) {
                try {
                    super.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.method.releaseConnection();
        }
    }
}

