/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.CreateBulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.IndexBulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.bulk.UpdateBulkFactory;

public abstract class BulkCommands {
    public static BulkCommand create(Settings settings, MetadataExtractor metaExtractor) {
        String operation = settings.getOperation();
        AbstractBulkFactory factory = null;
        if ("create".equals(operation)) {
            factory = new CreateBulkFactory(settings, metaExtractor);
        } else if ("index".equals(operation)) {
            factory = new IndexBulkFactory(settings, metaExtractor);
        } else if ("update".equals(operation)) {
            factory = new UpdateBulkFactory(settings, metaExtractor);
        } else if ("upsert".equals(operation)) {
            factory = new UpdateBulkFactory(settings, true, metaExtractor);
        } else {
            throw new EsHadoopIllegalArgumentException("Unknown operation " + operation);
        }
        return factory.createBulk();
    }
}

