/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ContentBuilder;
import org.elasticsearch.hadoop.serialization.builder.NoOpValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class InitializationUtils {
    public static void checkIdForOperation(Settings settings) {
        String operation = settings.getOperation();
        if ("update".equals(operation)) {
            Assert.isTrue(StringUtils.hasText(settings.getMappingId()), String.format("Operation [%s] requires an id but none (%s) was specified", operation, "es.mapping.id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean discoverNodesIfNeeded(Settings settings, Log log) {
        if (settings.getNodesDiscovery()) {
            RestClient bootstrap = new RestClient(settings);
            try {
                List<String> discoveredNodes = bootstrap.discoverNodes();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Nodes discovery enabled - found %s", discoveredNodes));
                }
                SettingsUtils.addDiscoveredNodes(settings, discoveredNodes);
            }
            finally {
                bootstrap.close();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterNonClientNodesIfNeeded(Settings settings, Log log) {
        if (!settings.getNodesClientOnly()) {
            return;
        }
        RestClient bootstrap = new RestClient(settings);
        try {
            String message = "Client-only routing specified but no client nodes with HTTP-enabled available";
            List<String> clientNodes = bootstrap.getHttpClientNodes();
            if (clientNodes.isEmpty()) {
                throw new EsHadoopIllegalArgumentException(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found client nodes %s", clientNodes));
            }
            List<String> ddNodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
            ddNodes.retainAll(clientNodes);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Filtered discovered only nodes %s to client-only %s", SettingsUtils.discoveredOrDeclaredNodes(settings), ddNodes));
            }
            if (ddNodes.isEmpty()) {
                message = settings.getNodesDiscovery() ? message + String.format("; looks like the client nodes discovered have been removed; is the cluster in a stable state? %s", clientNodes) : message + String.format("; node discovery is disabled and none of nodes specified fits the criterion %s", SettingsUtils.discoveredOrDeclaredNodes(settings));
                throw new EsHadoopIllegalArgumentException(message);
            }
            SettingsUtils.setDiscoveredNodes(settings, ddNodes);
        }
        finally {
            bootstrap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterNonDataNodesIfNeeded(Settings settings, Log log) {
        if (!settings.getNodesDataOnly() || settings.getNodesClientOnly()) {
            return;
        }
        RestClient bootstrap = new RestClient(settings);
        try {
            String message = "No data nodes with HTTP-enabled available";
            List<String> dataNodes = bootstrap.getHttpDataNodes();
            if (dataNodes.isEmpty()) {
                throw new EsHadoopIllegalArgumentException(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found data nodes %s", dataNodes));
            }
            List<String> ddNodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
            ddNodes.retainAll(dataNodes);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Filtered discovered only nodes %s to data-only %s", SettingsUtils.discoveredOrDeclaredNodes(settings), ddNodes));
            }
            if (ddNodes.isEmpty()) {
                message = settings.getNodesDiscovery() ? message + String.format("; looks like the data nodes discovered have been removed; is the cluster in a stable state? %s", dataNodes) : message + String.format("; node discovery is disabled and none of nodes specified fits the criterion %s", SettingsUtils.discoveredOrDeclaredNodes(settings));
                throw new EsHadoopIllegalArgumentException(message);
            }
            SettingsUtils.setDiscoveredNodes(settings, dataNodes);
        }
        finally {
            bootstrap.close();
        }
    }

    public static void validateSettings(Settings settings) {
        if (settings.getNodesWANOnly()) {
            Assert.isTrue(!settings.getNodesDiscovery(), "Discovery cannot be enabled when running in WAN mode");
            Assert.isTrue(!settings.getNodesClientOnly(), "Client-only nodes cannot be enabled when running in WAN mode");
            Assert.isTrue(!settings.getNodesDataOnly(), "Data-only nodes cannot be enabled when running in WAN mode");
        }
        Assert.isTrue(!settings.getNodesClientOnly() || !settings.getNodesDataOnly(), "Use either client-only or data-only nodes but not both");
        if (settings.getInputAsJson()) {
            Assert.isTrue(settings.getMappingIncludes().isEmpty(), "When writing data as JSON, the field inclusion feature is ignored. This is most likely not what the user intended. Bailing out...");
            Assert.isTrue(settings.getMappingExcludes().isEmpty(), "When writing data as JSON, the field exclusion feature is ignored. This is most likely not what the user intended. Bailing out...");
        }
    }

    public static String discoverEsVersion(Settings settings, Log log) {
        String version = settings.getProperty("es.internal.es.version");
        if (StringUtils.hasText(version)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Elasticsearch version [%s] already present in configuration; skipping discovery", version));
            }
            return version;
        }
        RestClient bootstrap = new RestClient(settings);
        try {
            String esVersion = bootstrap.esVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Discovered Elasticsearch version [%s]", esVersion));
            }
            if (!esVersion.startsWith("1.") && !esVersion.startsWith("2.")) {
                throw new EsHadoopIllegalArgumentException("Unsupported/Unknown Elasticsearch version " + esVersion);
            }
            settings.setProperty("es.internal.es.version", esVersion);
            String string = esVersion;
            return string;
        }
        catch (EsHadoopException ex) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot detect ES version - typically this happens if the network/Elasticsearch cluster is not accessible or when targeting a WAN/Cloud instance without the proper setting '%s'", "es.nodes.wan.only"), ex);
        }
        finally {
            bootstrap.close();
        }
    }

    public static void checkIndexExistence(RestRepository client) {
        InitializationUtils.checkIndexExistence(client.getSettings(), client);
    }

    public static void checkIndexExistence(Settings settings, RestRepository client) {
        if (!settings.getIndexAutoCreate()) {
            if (client == null) {
                client = new RestRepository(settings);
            }
            if (!client.indexExists(false)) {
                client.close();
                throw new EsHadoopIllegalArgumentException(String.format("Target index [%s] does not exist and auto-creation is disabled [setting '%s' is '%s']", settings.getResourceWrite(), "es.index.auto.create", settings.getIndexAutoCreate()));
            }
        }
    }

    public static boolean setFieldExtractorIfNotSet(Settings settings, Class<? extends FieldExtractor> clazz, Log log) {
        if (!StringUtils.hasText(settings.getMappingIdExtractorClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            settings.setProperty("es.mapping.default.extractor.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined field extractor [%s] as default", settings.getMappingIdExtractorClassName()));
            }
            return true;
        }
        return false;
    }

    public static <T> void saveSchemaIfNeeded(Object conf, ValueWriter<T> schemaWriter, T schema2, Log log) {
        Settings settings = HadoopSettingsManager.loadFrom(conf);
        if (settings.getIndexAutoCreate()) {
            RestRepository client = new RestRepository(settings);
            if (!client.indexExists(false)) {
                if (schemaWriter == null) {
                    log.warn((Object)String.format("No mapping found [%s] and no schema found; letting Elasticsearch perform auto-mapping...", settings.getResourceWrite()));
                } else {
                    log.info((Object)String.format("No mapping found [%s], creating one based on given schema", settings.getResourceWrite()));
                    ContentBuilder builder = ContentBuilder.generate(schemaWriter).value(schema2).flush();
                    BytesArray content = ((FastByteArrayOutputStream)builder.content()).bytes();
                    builder.close();
                    client.putMapping(content);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Creating ES mapping [%s] from schema [%s]", content.toString(), schema2));
                    }
                }
            }
            client.close();
        }
    }

    public static boolean setValueWriterIfNotSet(Settings settings, Class<? extends ValueWriter<?>> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueWriterClassName())) {
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            String name = clazz.getName();
            if (settings.getInputAsJson()) {
                name = NoOpValueWriter.class.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Elasticsearch input marked as JSON; bypassing serialization through [%s] instead of [%s]", name, clazz));
                }
            }
            settings.setProperty("es.ser.writer.value.class", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined writer serializer [%s] as default", settings.getSerializerValueWriterClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setBytesConverterIfNeeded(Settings settings, Class<? extends BytesConverter> clazz, Log log) {
        if (settings.getInputAsJson() && !StringUtils.hasText(settings.getSerializerBytesConverterClassName())) {
            Log logger;
            settings.setProperty("es.ser.writer.bytes.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("JSON input specified; using pre-defined bytes/json converter [%s] as default", settings.getSerializerBytesConverterClassName()));
            }
            return true;
        }
        return false;
    }

    public static boolean setValueReaderIfNotSet(Settings settings, Class<? extends ValueReader> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueReaderClassName())) {
            Log logger;
            settings.setProperty("es.ser.reader.value.class", clazz.getName());
            Log log2 = logger = log != null ? log : LogFactory.getLog(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Using pre-defined reader serializer [%s] as default", settings.getSerializerValueReaderClassName()));
            }
            return true;
        }
        return false;
    }
}

