/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto;

import java.io.Serializable;
import java.util.Map;
import org.elasticsearch.hadoop.util.StringUtils;

public class Node
implements Serializable {
    private String id;
    private String name;
    private boolean hasHttp;
    private String ipAddress;
    private int httpPort;
    private boolean isClient = false;
    private boolean isData = true;

    public Node(String id, String name, StringUtils.IpAndPort ipAndPort) {
        this.id = id;
        this.name = name;
        this.hasHttp = true;
        this.ipAddress = ipAndPort.ip;
        this.httpPort = ipAndPort.port;
        this.isData = false;
        this.isClient = false;
    }

    public Node(String id, Map<String, Object> data) {
        this.id = id;
        this.name = data.get("name").toString();
        Object http = data.get("http_address");
        this.hasHttp = http != null;
        Map attributes = (Map)data.get("attributes");
        if (attributes != null) {
            this.isClient = "false".equals(attributes.get("data")) && "false".equals(attributes.get("master"));
            boolean bl = this.isData = !"false".equals(attributes.get("data"));
        }
        if (!this.hasHttp) {
            return;
        }
        StringUtils.IpAndPort ip = StringUtils.parseIpAddress(http.toString());
        this.ipAddress = ip.ip;
        this.httpPort = ip.port;
    }

    public boolean hasHttp() {
        return this.hasHttp;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean isData() {
        return this.isData;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getInet() {
        return this.ipAddress + ":" + this.httpPort;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Node[id=").append(this.id).append(", name=").append(this.name).append(", ipAddress=").append(this.ipAddress).append(", httpPort=").append(this.httpPort).append(", isClient=").append(this.isClient).append(", isData=").append(this.isData).append("]");
        return builder.toString();
    }
}

