/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.mr.compat.CompatHandler;

public class MultiOutputFormat
extends OutputFormat
implements org.apache.hadoop.mapred.OutputFormat {
    public static final String CFG_FIELD = "es.hadoop.multi.of";
    private transient List<OutputFormat> newApiFormat = null;
    private transient List<org.apache.hadoop.mapred.OutputFormat> oldApiFormat = null;

    public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        List<org.apache.hadoop.mapred.OutputFormat> formats = this.getOldApiFormats((Configuration)job);
        ArrayList<RecordWriter> writers = new ArrayList<RecordWriter>();
        for (org.apache.hadoop.mapred.OutputFormat format : formats) {
            writers.add(format.getRecordWriter(ignored, job, name, progress));
        }
        return new MultiOldRecordWriter(writers);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        List<org.apache.hadoop.mapred.OutputFormat> formats = this.getOldApiFormats((Configuration)job);
        for (org.apache.hadoop.mapred.OutputFormat format : formats) {
            format.checkOutputSpecs(ignored, job);
        }
    }

    public org.apache.hadoop.mapreduce.RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        List<OutputFormat> formats = this.getNewApiFormats(CompatHandler.taskAttemptContext(context).getConfiguration());
        ArrayList<org.apache.hadoop.mapreduce.RecordWriter> writers = new ArrayList<org.apache.hadoop.mapreduce.RecordWriter>();
        for (OutputFormat format : formats) {
            writers.add(format.getRecordWriter(context));
        }
        return new MultiNewRecordWriter(writers);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        List<OutputFormat> formats = this.getNewApiFormats(CompatHandler.jobContext(context).getConfiguration());
        for (OutputFormat format : formats) {
            format.checkOutputSpecs(context);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        List<OutputFormat> formats = this.getNewApiFormats(CompatHandler.taskAttemptContext(context).getConfiguration());
        ArrayList<OutputCommitter> committers = new ArrayList<OutputCommitter>();
        for (OutputFormat format : formats) {
            committers.add(format.getOutputCommitter(context));
        }
        return new MultiNewOutputCommitter(committers);
    }

    public static void addOutputFormat(Configuration cfg, Class<? extends OutputFormat> ... formats) {
        Collection of = cfg.getStringCollection(CFG_FIELD);
        for (Class<? extends OutputFormat> format : formats) {
            of.add(format.getName());
        }
        cfg.setStrings(CFG_FIELD, new String[]{StringUtils.join((Collection)of, (String)",")});
    }

    private List<OutputFormat> getNewApiFormats(Configuration cfg) {
        if (this.newApiFormat == null) {
            this.newApiFormat = cfg.getInstances(CFG_FIELD, OutputFormat.class);
        }
        return this.newApiFormat;
    }

    private List<org.apache.hadoop.mapred.OutputFormat> getOldApiFormats(Configuration cfg) {
        if (this.oldApiFormat == null) {
            this.oldApiFormat = cfg.getInstances(CFG_FIELD, org.apache.hadoop.mapred.OutputFormat.class);
        }
        return this.oldApiFormat;
    }

    private static class MultiOldOutputCommitter
    extends org.apache.hadoop.mapred.OutputCommitter {
        private final List<org.apache.hadoop.mapred.OutputCommitter> committers;

        MultiOldOutputCommitter(List<org.apache.hadoop.mapred.OutputCommitter> committers) {
            this.committers = committers;
        }

        public void setupJob(org.apache.hadoop.mapred.JobContext jobContext) throws IOException {
            for (OutputCommitter outputCommitter : this.committers) {
                outputCommitter.setupJob((JobContext)jobContext);
            }
        }

        public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter outputCommitter : this.committers) {
                outputCommitter.setupTask((TaskAttemptContext)taskContext);
            }
        }

        public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
            boolean result = false;
            for (OutputCommitter outputCommitter : this.committers) {
                result |= outputCommitter.needsTaskCommit((TaskAttemptContext)taskContext);
            }
            return result;
        }

        public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter outputCommitter : this.committers) {
                outputCommitter.commitTask((TaskAttemptContext)taskContext);
            }
        }

        public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter outputCommitter : this.committers) {
                outputCommitter.abortTask((TaskAttemptContext)taskContext);
            }
        }

        @Deprecated
        public void cleanupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
            for (OutputCommitter outputCommitter : this.committers) {
                outputCommitter.cleanupJob((JobContext)context);
            }
        }
    }

    private static class MultiNewOutputCommitter
    extends OutputCommitter {
        private final List<OutputCommitter> committers;

        MultiNewOutputCommitter(List<OutputCommitter> committers) {
            this.committers = committers;
        }

        public void setupJob(JobContext jobContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.setupJob(jobContext);
            }
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.setupTask(taskContext);
            }
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            boolean result = false;
            for (OutputCommitter committer : this.committers) {
                result |= committer.needsTaskCommit(taskContext);
            }
            return result;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.commitTask(taskContext);
            }
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
            for (OutputCommitter committer : this.committers) {
                committer.abortTask(taskContext);
            }
        }
    }

    private static class MultiOldRecordWriter
    implements RecordWriter {
        private final List<RecordWriter> writers;

        public MultiOldRecordWriter(List<RecordWriter> writers) {
            this.writers = writers;
        }

        public void close(Reporter reporter) throws IOException {
            for (RecordWriter writer : this.writers) {
                writer.close(reporter);
            }
        }

        public void write(Object key, Object value) throws IOException {
            for (RecordWriter writer : this.writers) {
                writer.write(key, value);
            }
        }
    }

    private static class MultiNewRecordWriter
    extends org.apache.hadoop.mapreduce.RecordWriter {
        private final List<org.apache.hadoop.mapreduce.RecordWriter> writers;

        public MultiNewRecordWriter(List<org.apache.hadoop.mapreduce.RecordWriter> writers) {
            this.writers = writers;
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            for (org.apache.hadoop.mapreduce.RecordWriter writer : this.writers) {
                writer.write(key, value);
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            for (org.apache.hadoop.mapreduce.RecordWriter writer : this.writers) {
                writer.close(context);
            }
        }
    }
}

