/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.NetworkUtils;
import org.elasticsearch.hadoop.rest.PartitionDefinition;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.rest.SearchRequestBuilder;
import org.elasticsearch.hadoop.rest.query.BoolQueryBuilder;
import org.elasticsearch.hadoop.rest.query.ConstantScoreQueryBuilder;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.rest.query.QueryUtils;
import org.elasticsearch.hadoop.rest.query.RawQueryBuilder;
import org.elasticsearch.hadoop.rest.request.GetAliasesRequestBuilder;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.IndicesAliases;
import org.elasticsearch.hadoop.serialization.dto.NodeInfo;
import org.elasticsearch.hadoop.serialization.dto.ShardInfo;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingSet;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.Version;

public abstract class RestService
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<PartitionDefinition> findPartitions(Settings settings, Log log) {
        Version.logVersion();
        InitializationUtils.validateSettings(settings);
        InitializationUtils.validateSettingsForReading(settings);
        EsMajorVersion version = InitializationUtils.discoverEsVersion(settings, log);
        List<NodeInfo> nodes = InitializationUtils.discoverNodesIfNeeded(settings, log);
        InitializationUtils.filterNonClientNodesIfNeeded(settings, log);
        InitializationUtils.filterNonDataNodesIfNeeded(settings, log);
        InitializationUtils.filterNonIngestNodesIfNeeded(settings, log);
        RestRepository client = new RestRepository(settings);
        try {
            boolean indexExists = client.indexExists(true);
            List<List<Map<String, Object>>> shards = null;
            if (!indexExists) {
                if (!settings.getIndexReadMissingAsEmpty()) throw new EsHadoopIllegalArgumentException(String.format("Index [%s] missing and settings [%s] is set to false", settings.getResourceRead(), "es.index.read.missing.as.empty"));
                log.info((Object)String.format("Index [%s] missing - treating it as empty", settings.getResourceRead()));
                shards = Collections.emptyList();
            } else {
                shards = client.getReadTargetShards();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Creating splits for shards " + shards));
                }
            }
            log.info((Object)String.format("Reading from [%s]", settings.getResourceRead()));
            MappingSet mapping = null;
            if (!shards.isEmpty()) {
                FieldPresenceValidation validation;
                mapping = client.getMappings();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Discovered resolved mapping {%s} for [%s]", mapping.getResolvedView(), settings.getResourceRead()));
                }
                if ((validation = settings.getReadFieldExistanceValidation()).isRequired()) {
                    MappingUtils.validateMapping(SettingsUtils.determineSourceFields(settings), mapping.getResolvedView(), validation, log);
                }
            }
            HashMap<String, NodeInfo> nodesMap = new HashMap<String, NodeInfo>();
            if (nodes != null) {
                for (NodeInfo node : nodes) {
                    nodesMap.put(node.getId(), node);
                }
            }
            List<PartitionDefinition> partitions = version.onOrAfter(EsMajorVersion.V_5_X) ? RestService.findSlicePartitions(client.getRestClient(), settings, mapping, nodesMap, shards, log) : RestService.findShardPartitions(settings, mapping, nodesMap, shards, log);
            Collections.shuffle(partitions);
            List<PartitionDefinition> list = partitions;
            return list;
        }
        finally {
            client.close();
        }
    }

    static List<PartitionDefinition> findShardPartitions(Settings settings, MappingSet mappingSet, Map<String, NodeInfo> nodes, List<List<Map<String, Object>>> shards, Log log) {
        Mapping resolvedMapping = mappingSet == null ? null : mappingSet.getResolvedView();
        ArrayList<PartitionDefinition> partitions = new ArrayList<PartitionDefinition>(shards.size());
        for (List<Map<String, Object>> group : shards) {
            String index = null;
            int shardId = -1;
            ArrayList<String> locationList = new ArrayList<String>();
            for (Map<String, Object> replica : group) {
                ShardInfo shard = new ShardInfo(replica);
                index = shard.getIndex();
                shardId = shard.getName();
                if (!nodes.containsKey(shard.getNode())) continue;
                locationList.add(nodes.get(shard.getNode()).getPublishAddress());
            }
            if (index == null) {
                if (settings.getIndexReadAllowRedStatus()) {
                    log.warn((Object)"Shard information is missing from an index and will not be reached during job execution. Assuming shard is unavailable and cluster is red! Continuing with read operation by skipping this shard! This may result in incomplete data retrieval!");
                    continue;
                }
                throw new IllegalStateException("Could not locate shard information for one of the read indices. Check your cluster status to see if it is unstable!");
            }
            PartitionDefinition partition = new PartitionDefinition(settings, resolvedMapping, index, shardId, locationList.toArray(new String[0]));
            partitions.add(partition);
        }
        return partitions;
    }

    static List<PartitionDefinition> findSlicePartitions(RestClient client, Settings settings, MappingSet mappingSet, Map<String, NodeInfo> nodes, List<List<Map<String, Object>>> shards, Log log) {
        QueryBuilder query = QueryUtils.parseQueryAndFilters(settings);
        int maxDocsPerPartition = settings.getMaxDocsPerPartition();
        String types = new Resource(settings, true).type();
        Mapping resolvedMapping = mappingSet == null ? null : mappingSet.getResolvedView();
        ArrayList<PartitionDefinition> partitions = new ArrayList<PartitionDefinition>(shards.size());
        for (List<Map<String, Object>> group : shards) {
            String index = null;
            int shardId = -1;
            ArrayList<String> locationList = new ArrayList<String>();
            for (Map<String, Object> replica : group) {
                ShardInfo shard = new ShardInfo(replica);
                index = shard.getIndex();
                shardId = shard.getName();
                if (!nodes.containsKey(shard.getNode())) continue;
                locationList.add(nodes.get(shard.getNode()).getPublishAddress());
            }
            String[] locations = locationList.toArray(new String[0]);
            if (index == null) {
                if (settings.getIndexReadAllowRedStatus()) {
                    log.warn((Object)"Shard information is missing from an index and will not be reached during job execution. Assuming shard is unavailable and cluster is red! Continuing with read operation by skipping this shard! This may result in incomplete data retrieval!");
                    continue;
                }
                throw new IllegalStateException("Could not locate shard information for one of the read indices. Check your cluster status to see if it is unstable!");
            }
            StringBuilder indexAndType = new StringBuilder(index);
            if (StringUtils.hasLength(types)) {
                indexAndType.append("/");
                indexAndType.append(types);
            }
            long numDocs = client.count(indexAndType.toString(), Integer.toString(shardId), query);
            int numPartitions = (int)Math.max(1L, numDocs / (long)maxDocsPerPartition);
            for (int i = 0; i < numPartitions; ++i) {
                PartitionDefinition.Slice slice = new PartitionDefinition.Slice(i, numPartitions);
                partitions.add(new PartitionDefinition(settings, resolvedMapping, index, shardId, slice, locations));
            }
        }
        return partitions;
    }

    static String checkLocality(String[] locations, Log log) {
        block6: {
            try {
                InetAddress[] candidates = NetworkUtils.getGlobalInterfaces();
                for (String address : locations) {
                    StringUtils.IpAndPort ipAndPort = StringUtils.parseIpAddress(address);
                    InetAddress addr = InetAddress.getByName(ipAndPort.ip);
                    for (InetAddress candidate : candidates) {
                        if (!addr.equals(candidate)) continue;
                        return address;
                    }
                }
            }
            catch (SocketException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to retrieve the global interfaces of the system", (Throwable)e);
                }
            }
            catch (UnknownHostException e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"Unable to retrieve IP address", (Throwable)e);
            }
        }
        return null;
    }

    public static PartitionReader createReader(Settings settings, PartitionDefinition partition, Log log) {
        IndicesAliases indicesAliases;
        Map<String, IndicesAliases.Alias> aliases;
        String pinAddress;
        if (!SettingsUtils.hasPinnedNode(settings) && partition.getLocations().length > 0 && (pinAddress = RestService.checkLocality(partition.getLocations(), log)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Partition reader instance [%s] assigned to [%s]:[%s]", partition, pinAddress));
            }
            SettingsUtils.pinNode(settings, pinAddress);
        }
        EsMajorVersion version = InitializationUtils.discoverEsVersion(settings, log);
        ValueReader reader = (ValueReader)ObjectUtils.instantiate(settings.getSerializerValueReaderClassName(), settings);
        RestRepository repository = new RestRepository(settings);
        Mapping fieldMapping = null;
        if (StringUtils.hasText(partition.getSerializedMapping())) {
            fieldMapping = (Mapping)IOUtils.deserializeFromBase64(partition.getSerializedMapping());
        } else {
            log.warn((Object)String.format("No mapping found for [%s] - either no index exists or the partition configuration has been corrupted", partition));
        }
        ScrollReader scrollReader = new ScrollReader(new ScrollReader.ScrollReaderConfig(reader, fieldMapping, settings));
        if (settings.getNodesClientOnly()) {
            String clientNode = repository.getRestClient().getCurrentNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Client-node routing detected; partition reader instance [%s] assigned to [%s]", partition, clientNode));
            }
            SettingsUtils.pinNode(settings, clientNode);
        }
        boolean includeVersion = settings.getReadMetadata() && settings.getReadMetadataVersion();
        Resource read = new Resource(settings, true);
        SearchRequestBuilder requestBuilder = new SearchRequestBuilder(version, includeVersion).types(read.type()).indices(partition.getIndex()).query(QueryUtils.parseQuery(settings)).scroll(settings.getScrollKeepAlive()).size(settings.getScrollSize()).limit(settings.getScrollLimit()).fields(SettingsUtils.determineSourceFields(settings)).filters(QueryUtils.parseFilters(settings)).shard(Integer.toString(partition.getShardId())).local(true).excludeSource(settings.getExcludeSource());
        if (partition.getSlice() != null && partition.getSlice().max > 1) {
            requestBuilder.slice(partition.getSlice().id, partition.getSlice().max);
        }
        String[] indices = read.index().split(",");
        if (!QueryUtils.isExplicitlyRequested(partition.getIndex(), indices) && (aliases = (indicesAliases = new GetAliasesRequestBuilder(repository.getRestClient()).indices(partition.getIndex()).execute().getIndices()).getAliases(partition.getIndex())) != null && aliases.size() > 0) {
            requestBuilder = RestService.applyAliasMetadata(version, aliases, requestBuilder, partition.getIndex(), indices);
        }
        return new PartitionReader(scrollReader, repository, requestBuilder);
    }

    static SearchRequestBuilder applyAliasMetadata(EsMajorVersion version, Map<String, IndicesAliases.Alias> aliases, SearchRequestBuilder searchRequestBuilder, String index, String ... indicesOrAliases) {
        if (QueryUtils.isExplicitlyRequested(index, indicesOrAliases)) {
            return searchRequestBuilder;
        }
        HashSet<String> routing = new HashSet<String>();
        ArrayList<RawQueryBuilder> aliasFilters = new ArrayList<RawQueryBuilder>();
        for (IndicesAliases.Alias alias : aliases.values()) {
            if (!QueryUtils.isExplicitlyRequested(alias.getName(), indicesOrAliases)) continue;
            if (StringUtils.hasLength(alias.getSearchRouting())) {
                for (String value : alias.getSearchRouting().split(",")) {
                    routing.add(value.trim());
                }
            }
            if (alias.getFilter() == null) continue;
            try {
                aliasFilters.add(new RawQueryBuilder(alias.getFilter(), false));
            }
            catch (IOException iOException) {
                throw new EsHadoopIllegalArgumentException("Failed to parse alias filter: [" + alias.getFilter() + "]");
            }
        }
        if (aliasFilters.size() > 0) {
            QueryBuilder aliasQuery;
            if (aliasFilters.size() == 1) {
                aliasQuery = (QueryBuilder)aliasFilters.get(0);
            } else {
                aliasQuery = new BoolQueryBuilder();
                for (QueryBuilder queryBuilder : aliasFilters) {
                    ((BoolQueryBuilder)aliasQuery).should(queryBuilder);
                }
            }
            if (searchRequestBuilder.query() == null) {
                searchRequestBuilder.query(aliasQuery);
            } else {
                BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                boolQueryBuilder.must(searchRequestBuilder.query());
                if (version.after(EsMajorVersion.V_1_X)) {
                    boolQueryBuilder.filter(aliasQuery);
                } else {
                    boolQueryBuilder.must(new ConstantScoreQueryBuilder().filter(aliasQuery).boost(0.0f));
                }
                searchRequestBuilder.query(boolQueryBuilder);
            }
        }
        if (routing.size() > 0) {
            searchRequestBuilder.routing(StringUtils.concatenate(routing, ","));
        }
        return searchRequestBuilder;
    }

    public static List<PartitionDefinition> assignPartitions(List<PartitionDefinition> partitions, int currentTask, int totalTasks) {
        int esPartitions = partitions.size();
        if (totalTasks >= esPartitions) {
            return currentTask >= esPartitions ? Collections.emptyList() : Collections.singletonList(partitions.get(currentTask));
        }
        int partitionsPerTask = esPartitions / totalTasks;
        int remainder = esPartitions % totalTasks;
        int partitionsPerCurrentTask = partitionsPerTask;
        if (currentTask < remainder) {
            ++partitionsPerCurrentTask;
        }
        int offset = partitionsPerTask * currentTask;
        if (currentTask != 0) {
            offset += remainder > currentTask ? 1 : remainder;
        }
        if (partitionsPerCurrentTask == 1) {
            return Collections.singletonList(partitions.get(offset));
        }
        ArrayList<PartitionDefinition> pa = new ArrayList<PartitionDefinition>(partitionsPerCurrentTask);
        for (int index = offset; index < offset + partitionsPerCurrentTask; ++index) {
            pa.add(partitions.get(index));
        }
        return pa;
    }

    public static MultiReaderIterator multiReader(Settings settings, List<PartitionDefinition> definitions, Log log) {
        return new MultiReaderIterator(definitions, settings, log);
    }

    public static PartitionWriter createWriter(Settings settings, int currentSplit, int totalSplits, Log log) {
        Version.logVersion();
        InitializationUtils.validateSettings(settings);
        InitializationUtils.discoverEsVersion(settings, log);
        InitializationUtils.discoverNodesIfNeeded(settings, log);
        InitializationUtils.filterNonClientNodesIfNeeded(settings, log);
        InitializationUtils.filterNonDataNodesIfNeeded(settings, log);
        InitializationUtils.filterNonIngestNodesIfNeeded(settings, log);
        List<String> nodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
        int selectedNode = currentSplit < 0 ? new Random().nextInt(nodes.size()) : currentSplit % nodes.size();
        SettingsUtils.pinNode(settings, nodes.get(selectedNode));
        Resource resource = new Resource(settings, false);
        log.info((Object)String.format("Writing to [%s]", resource));
        IndexExtractor iformat = (IndexExtractor)ObjectUtils.instantiate(settings.getMappingIndexExtractorClassName(), settings);
        iformat.compile(resource.toString());
        RestRepository repository = iformat.hasPattern() ? RestService.initMultiIndices(settings, currentSplit, resource, log) : RestService.initSingleIndex(settings, currentSplit, resource, log);
        return new PartitionWriter(settings, currentSplit, totalSplits, repository);
    }

    private static RestRepository initSingleIndex(Settings settings, int currentInstance, Resource resource, Log log) {
        RestRepository repository;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resource [%s] resolves as a single index", resource));
        }
        if ((repository = new RestRepository(settings)).touch() && repository.waitForYellow()) {
            log.warn((Object)String.format("Timed out waiting for index [%s] to reach yellow health", resource));
        }
        if (settings.getNodesWANOnly()) {
            return RestService.randomNodeWrite(settings, currentInstance, resource, log);
        }
        if (settings.getNodesClientOnly()) {
            String clientNode = repository.getRestClient().getCurrentNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Client-node routing detected; partition writer instance [%s] assigned to [%s]", currentInstance, clientNode));
            }
            return repository;
        }
        Map<Object, Object> targetShards = Collections.emptyMap();
        targetShards = repository.getWriteTargetPrimaryShards(settings.getNodesClientOnly());
        repository.close();
        Assert.isTrue(!targetShards.isEmpty(), String.format("Cannot determine write shards for [%s]; likely its format is incorrect (maybe it contains illegal characters?)", resource));
        ArrayList<Object> orderedShards = new ArrayList<Object>(targetShards.keySet());
        Collections.sort(orderedShards);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Partition writer instance [%s] discovered [%s] primary shards %s", currentInstance, orderedShards.size(), orderedShards));
        }
        if (currentInstance <= 0) {
            currentInstance = new Random().nextInt(targetShards.size()) + 1;
        }
        int bucket = currentInstance % targetShards.size();
        ShardInfo chosenShard = (ShardInfo)orderedShards.get(bucket);
        NodeInfo targetNode = (NodeInfo)targetShards.get(chosenShard);
        SettingsUtils.pinNode(settings, targetNode.getPublishAddress());
        String node = SettingsUtils.getPinnedNode(settings);
        repository = new RestRepository(settings);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Partition writer instance [%s] assigned to primary shard [%s] at address [%s]", currentInstance, chosenShard.getName(), node));
        }
        return repository;
    }

    private static RestRepository initMultiIndices(Settings settings, int currentInstance, Resource resource, Log log) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resource [%s] resolves as an index pattern", resource));
        }
        return RestService.randomNodeWrite(settings, currentInstance, resource, log);
    }

    private static RestRepository randomNodeWrite(Settings settings, int currentInstance, Resource resource, Log log) {
        List<String> nodes = SettingsUtils.discoveredOrDeclaredNodes(settings);
        String node = nodes.get(new Random().nextInt(nodes.size()));
        SettingsUtils.pinNode(settings, node);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Partition writer instance [%s] assigned to [%s]", currentInstance, node));
        }
        return new RestRepository(settings);
    }

    public static class MultiReaderIterator
    implements Closeable,
    Iterator {
        private final List<PartitionDefinition> definitions;
        private final Iterator<PartitionDefinition> definitionIterator;
        private PartitionReader currentReader;
        private ScrollQuery currentScroll;
        private boolean finished = false;
        private final Settings settings;
        private final Log log;

        MultiReaderIterator(List<PartitionDefinition> defs, Settings settings, Log log) {
            this.definitions = defs;
            this.definitionIterator = defs.iterator();
            this.settings = settings;
            this.log = log;
        }

        @Override
        public void close() {
            if (this.finished) {
                return;
            }
            ScrollQuery sq = this.getCurrent();
            if (sq != null) {
                sq.close();
            }
            if (this.currentReader != null) {
                this.currentReader.close();
            }
            this.finished = true;
        }

        @Override
        public boolean hasNext() {
            ScrollQuery sq = this.getCurrent();
            return sq != null ? sq.hasNext() : false;
        }

        private ScrollQuery getCurrent() {
            if (this.finished) {
                return null;
            }
            boolean hasValue = false;
            while (!hasValue) {
                if (this.currentReader == null) {
                    if (this.definitionIterator.hasNext()) {
                        this.currentReader = RestService.createReader(this.settings, this.definitionIterator.next(), this.log);
                    } else {
                        this.finished = true;
                        return null;
                    }
                }
                if (this.currentScroll == null) {
                    this.currentScroll = this.currentReader.scrollQuery();
                }
                if (hasValue = this.currentScroll.hasNext()) continue;
                this.currentScroll.close();
                this.currentScroll = null;
                this.currentReader.close();
                this.currentReader = null;
            }
            return this.currentScroll;
        }

        public Object[] next() {
            ScrollQuery sq = this.getCurrent();
            return sq.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PartitionWriter
    implements Closeable {
        public final RestRepository repository;
        public final int number;
        public final int total;
        public final Settings settings;
        private boolean closed = false;

        PartitionWriter(Settings settings, int splitIndex, int splitsSize, RestRepository repository) {
            this.settings = settings;
            this.repository = repository;
            this.number = splitIndex;
            this.total = splitsSize;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.repository.close();
            }
        }
    }

    public static class PartitionReader
    implements Closeable {
        public final ScrollReader scrollReader;
        public final RestRepository client;
        public final SearchRequestBuilder queryBuilder;
        private ScrollQuery scrollQuery;
        private boolean closed = false;

        PartitionReader(ScrollReader scrollReader, RestRepository client, SearchRequestBuilder queryBuilder) {
            this.scrollReader = scrollReader;
            this.client = client;
            this.queryBuilder = queryBuilder;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                if (this.scrollQuery != null) {
                    this.scrollQuery.close();
                }
                this.client.close();
            }
        }

        public ScrollQuery scrollQuery() {
            if (this.scrollQuery == null) {
                this.scrollQuery = this.queryBuilder.build(this.client, this.scrollReader);
            }
            return this.scrollQuery;
        }
    }
}

