/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.pooling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Transport;
import org.elasticsearch.hadoop.rest.TransportFactory;
import org.elasticsearch.hadoop.rest.pooling.TransportPool;
import org.elasticsearch.hadoop.util.SettingsUtils;

final class PooledHttpTransportFactory
implements TransportFactory {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<String, TransportPool> hostPools = new HashMap<String, TransportPool>();
    private final String jobKey;

    PooledHttpTransportFactory(String jobKey) {
        this.jobKey = jobKey;
    }

    @Override
    public synchronized Transport create(Settings settings, String hostInfo) {
        this.assertCorrectJobId(settings);
        return this.borrowFrom(this.getOrCreateTransportPool(hostInfo, settings), hostInfo);
    }

    private void assertCorrectJobId(Settings settings) {
        SettingsUtils.ensureJobTransportPoolingKey(settings);
        String requestingJobKey = SettingsUtils.getJobTransportPoolingKey(settings);
        if (!this.jobKey.equals(requestingJobKey)) {
            throw new EsHadoopIllegalArgumentException("Settings object passed does not have the same job pooling key property as when this pool was created. Job key requested was [" + requestingJobKey + "] but this pool services job [" + this.jobKey + "]. This could be a different job incorrectly polluting the TransportPool. Bailing out...");
        }
    }

    private TransportPool getOrCreateTransportPool(String hostInfo, Settings settings) {
        TransportPool pool = this.hostPools.get(hostInfo);
        if (pool == null) {
            pool = new TransportPool(this.jobKey, hostInfo, settings);
            this.hostPools.put(hostInfo, pool);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating new TransportPool for job [" + this.jobKey + "] for host [" + hostInfo + "]"));
            }
        }
        return pool;
    }

    private Transport borrowFrom(TransportPool pool, String hostInfo) {
        if (!pool.getJobPoolingKey().equals(this.jobKey)) {
            throw new EsHadoopIllegalArgumentException("PooledTransportFactory found a pool with a different owner than this job. This could be a different job incorrectly polluting the TransportPool. Bailing out...");
        }
        try {
            return pool.borrowTransport();
        }
        catch (Exception ex) {
            throw new EsHadoopException(String.format("Could not get a Transport from the Transport Pool for host [%s]", hostInfo), ex);
        }
    }

    synchronized int cleanPools() {
        int totalConnectionsRemaining = 0;
        ArrayList<String> hostsToRemove = new ArrayList<String>();
        for (Map.Entry<String, TransportPool> hostPool : this.hostPools.entrySet()) {
            String host = hostPool.getKey();
            TransportPool pool = hostPool.getValue();
            int connectionsRemaining = pool.removeOldConnections();
            if (connectionsRemaining == 0) {
                hostsToRemove.add(host);
                continue;
            }
            totalConnectionsRemaining += connectionsRemaining;
        }
        for (String hostToRemove : hostsToRemove) {
            this.hostPools.remove(hostToRemove);
        }
        return totalConnectionsRemaining;
    }
}

