/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.ErrorExtractor;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.EsHadoopParsingException;
import org.elasticsearch.hadoop.rest.HttpRetryPolicy;
import org.elasticsearch.hadoop.rest.NetworkClient;
import org.elasticsearch.hadoop.rest.NoHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.SimpleHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.SimpleRequest;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.dto.NodeInfo;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.serialization.json.JsonFactory;
import org.elasticsearch.hadoop.serialization.json.ObjectReader;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.encoding.HttpEncodingTools;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestClient
implements Closeable,
StatsAware {
    private static final int MAX_BULK_ERROR_MESSAGES = 5;
    private NetworkClient network;
    private final ObjectMapper mapper = new ObjectMapper();
    private final TimeValue scrollKeepAlive;
    private final boolean indexReadMissingAsEmpty;
    private final HttpRetryPolicy retryPolicy;
    final EsMajorVersion internalVersion;
    private final ErrorExtractor errorExtractor;
    private final Stats stats;

    public RestClient(Settings settings) {
        this(settings, new NetworkClient(settings));
    }

    RestClient(Settings settings, NetworkClient networkClient) {
        this.mapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, false);
        this.mapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, false);
        this.stats = new Stats();
        this.network = networkClient;
        this.scrollKeepAlive = TimeValue.timeValueMillis(settings.getScrollKeepAlive());
        this.indexReadMissingAsEmpty = settings.getIndexReadMissingAsEmpty();
        String retryPolicyName = settings.getBatchWriteRetryPolicy();
        if ("simple".equals(retryPolicyName)) {
            retryPolicyName = SimpleHttpRetryPolicy.class.getName();
        } else if ("none".equals(retryPolicyName)) {
            retryPolicyName = NoHttpRetryPolicy.class.getName();
        }
        this.retryPolicy = (HttpRetryPolicy)ObjectUtils.instantiate(retryPolicyName, settings);
        this.internalVersion = settings.getInternalVersionOrLatest();
        this.errorExtractor = new ErrorExtractor(this.internalVersion);
    }

    public List<NodeInfo> getHttpNodes(boolean clientNodeOnly) {
        Map nodesData = (Map)this.get("_nodes/http", "nodes");
        ArrayList<NodeInfo> nodes = new ArrayList<NodeInfo>();
        for (Map.Entry entry : nodesData.entrySet()) {
            NodeInfo node = new NodeInfo((String)entry.getKey(), (Map)entry.getValue());
            if (!node.hasHttp() || clientNodeOnly && !node.isClient()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List<NodeInfo> getHttpClientNodes() {
        return this.getHttpNodes(true);
    }

    public List<NodeInfo> getHttpDataNodes() {
        List<NodeInfo> nodes = this.getHttpNodes(false);
        Iterator<NodeInfo> it = nodes.iterator();
        while (it.hasNext()) {
            NodeInfo node = it.next();
            if (node.isData()) continue;
            it.remove();
        }
        return nodes;
    }

    public List<NodeInfo> getHttpIngestNodes() {
        List<NodeInfo> nodes = this.getHttpNodes(false);
        Iterator<NodeInfo> it = nodes.iterator();
        while (it.hasNext()) {
            NodeInfo nodeInfo = it.next();
            if (nodeInfo.isIngest()) continue;
            it.remove();
        }
        return nodes;
    }

    public <T> T get(String q, String string) {
        return this.parseContent(this.execute(Request.Method.GET, q), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parseContent(InputStream content, String string) {
        Map map = Collections.emptyMap();
        try {
            JsonParser jsonParser = this.mapper.getJsonFactory().createJsonParser(content);
            try {
                map = (Map)this.mapper.readValue(jsonParser, Map.class);
            }
            finally {
                this.countStreamStats(content);
            }
        }
        catch (IOException ex) {
            throw new EsHadoopParsingException(ex);
        }
        return (T)(string != null ? map.get(string) : map);
    }

    public BulkActionResponse bulk(Resource resource, TrackingBytesArray data) {
        long start = this.network.transportStats().netTotalTime;
        Response response = this.execute(Request.Method.PUT, resource.bulk(), data);
        long spent = this.network.transportStats().netTotalTime - start;
        ++this.stats.bulkTotal;
        this.stats.docsSent += (long)data.entries();
        this.stats.bulkTotalTime += spent;
        return new BulkActionResponse(this.parseBulkActionResponse(response), response.status(), spent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Iterator<Map> parseBulkActionResponse(Response response) {
        InputStream content = response.body();
        try {
            ObjectReader r = JsonFactory.objectReader(this.mapper, Map.class);
            JsonParser parser = this.mapper.getJsonFactory().createJsonParser(content);
            try {
                if (ParsingUtils.seek((Parser)new JacksonJsonParser(parser), "items") == null) {
                    Iterator<Map> iterator = Collections.emptyList().iterator();
                    return iterator;
                }
                Iterator<Map> iterator = r.readValues(parser);
                return iterator;
            }
            finally {
                this.countStreamStats(content);
            }
        }
        catch (IOException ex) {
            throw new EsHadoopParsingException(ex);
        }
    }

    public String postDocument(Resource resource, BytesArray document) throws IOException {
        SimpleRequest request = new SimpleRequest(Request.Method.POST, null, resource.index() + "/" + resource.type(), null, document);
        Response response = this.execute(request, true);
        Object id = this.parseContent(response.body(), "_id");
        if (id == null || !StringUtils.hasText(id.toString())) {
            throw new EsHadoopInvalidRequest(String.format("Could not determine successful write operation. Request[%s > %s] Response[%s]", new Object[]{request.method(), request.path(), IOUtils.asString(response.body())}));
        }
        return id.toString();
    }

    public void refresh(Resource resource) {
        this.execute(Request.Method.POST, resource.refresh());
    }

    public List<List<Map<String, Object>>> targetShards(String index, String routing) {
        SimpleRequest req;
        Response res;
        List shardsJson = null;
        String target = index + "/_search_shards";
        if (routing != null) {
            target = target + "?routing=" + HttpEncodingTools.encode(routing);
        }
        shardsJson = this.indexReadMissingAsEmpty ? ((res = this.executeNotFoundAllowed(req = new SimpleRequest(Request.Method.GET, null, target))).status() == 200 ? (List)this.parseContent(res.body(), "shards") : Collections.emptyList()) : (List)this.get(target, "shards");
        return shardsJson;
    }

    public Map<String, Object> getMapping(String query) {
        return (Map)this.get(query, null);
    }

    public Map<String, Object> sampleForFields(String index, String type, Collection<String> fields) {
        Map hits;
        List docs;
        if (fields == null || fields.isEmpty()) {
            return Collections.emptyMap();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"terminate_after\":1, \"size\":1,\n");
        sb.append("\"_source\": [");
        for (String field : fields) {
            sb.append(String.format(Locale.ROOT, "\"%s\",", field));
        }
        sb.setLength(sb.length() - 1);
        sb.append("],\n\"query\":{");
        if (this.internalVersion.onOrAfter(EsMajorVersion.V_2_X)) {
            sb.append("\"bool\": { \"must\":[");
        } else {
            sb.append("\"constant_score\":{ \"filter\": { \"and\":[");
        }
        for (String field : fields) {
            sb.append(String.format(Locale.ROOT, "\n{ \"exists\":{ \"field\":\"%s\"} },", field));
        }
        sb.setLength(sb.length() - 1);
        sb.append("\n]}");
        if (this.internalVersion.on(EsMajorVersion.V_1_X)) {
            sb.append("}");
        }
        sb.append("}}");
        String endpoint = index;
        if (StringUtils.hasText(type)) {
            endpoint = index + "/" + type;
        }
        if ((docs = (List)(hits = (Map)this.parseContent(this.execute(Request.Method.GET, endpoint + "/_search", new BytesArray(sb.toString())).body(), "hits")).get("hits")) == null || docs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map foundFields = (Map)docs.get(0);
        Map fieldInfo = (Map)foundFields.get("_source");
        return fieldInfo;
    }

    @Override
    public void close() {
        if (this.network != null) {
            this.network.close();
            this.stats.aggregate(this.network.stats());
            this.network = null;
        }
    }

    protected InputStream execute(Request request) {
        return this.execute(request, true).body();
    }

    protected InputStream execute(Request.Method method, String path) {
        return this.execute(new SimpleRequest(method, null, path));
    }

    protected Response execute(Request.Method method, String path, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, path), checkStatus);
    }

    protected InputStream execute(Request.Method method, String path, String params2) {
        return this.execute(new SimpleRequest(method, null, (CharSequence)path, params2));
    }

    protected Response execute(Request.Method method, String path, String params2, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, (CharSequence)path, params2), checkStatus);
    }

    protected Response execute(Request.Method method, String path, ByteSequence buffer) {
        return this.execute(new SimpleRequest(method, null, path, null, buffer), true);
    }

    protected Response execute(Request.Method method, String path, ByteSequence buffer, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, path, null, buffer), checkStatus);
    }

    protected Response execute(Request.Method method, String path, String params2, ByteSequence buffer) {
        return this.execute(new SimpleRequest(method, null, path, params2, buffer), true);
    }

    protected Response execute(Request.Method method, String path, String params2, ByteSequence buffer, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, path, params2, buffer), checkStatus);
    }

    protected Response execute(Request request, boolean checkStatus) {
        Response response = this.network.execute(request);
        if (checkStatus) {
            this.checkResponse(request, response);
        }
        return response;
    }

    protected Response executeNotFoundAllowed(Request req) {
        Response res = this.execute(req, false);
        switch (res.status()) {
            case 200: {
                break;
            }
            case 404: {
                break;
            }
            default: {
                this.checkResponse(req, res);
            }
        }
        return res;
    }

    private void checkResponse(Request request, Response response) {
        if (response.hasFailed()) {
            String msg = null;
            try {
                EsHadoopException ex = this.errorExtractor.extractError((Map)this.parseContent(response.body(), null));
                String string = msg = ex != null ? ex.toString() : null;
                msg = response.isClientError() ? msg + "\n" + request.body() : this.errorExtractor.prettify(msg, request.body());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!StringUtils.hasText(msg)) {
                msg = String.format("[%s] on [%s] failed; server[%s] returned [%s|%s:%s]", request.method().name(), request.path(), response.uri(), response.status(), response.statusDescription(), IOUtils.asStringAlways(response.body()));
            }
            throw new EsHadoopInvalidRequest(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream scroll(String scrollId) {
        long start = this.network.transportStats().netTotalTime;
        try {
            BytesArray body = this.internalVersion.onOrAfter(EsMajorVersion.V_2_X) ? new BytesArray("{\"scroll_id\":\"" + scrollId + "\"}") : new BytesArray(scrollId);
            InputStream is = this.execute(Request.Method.POST, "_search/scroll?scroll=" + this.scrollKeepAlive.toString(), body).body();
            ++this.stats.scrollTotal;
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            this.stats.scrollTotalTime += this.network.transportStats().netTotalTime - start;
        }
    }

    public boolean delete(String indexOrType) {
        SimpleRequest req = new SimpleRequest(Request.Method.DELETE, null, indexOrType);
        Response res = this.executeNotFoundAllowed(req);
        return res.status() == 200;
    }

    public boolean deleteScroll(String scrollId) {
        BytesArray body = this.internalVersion.onOrAfter(EsMajorVersion.V_2_X) ? new BytesArray(("{\"scroll_id\":[\"" + scrollId + "\"]}").getBytes(StringUtils.UTF_8)) : new BytesArray(scrollId.getBytes(StringUtils.UTF_8));
        SimpleRequest req = new SimpleRequest(Request.Method.DELETE, null, (CharSequence)"_search/scroll", body);
        Response res = this.executeNotFoundAllowed(req);
        return res.status() == 200;
    }

    public boolean documentExists(String index, String type, String id) {
        return this.exists(index + "/" + type + "/" + id);
    }

    public boolean typeExists(String index, String type) {
        String indexType = this.internalVersion.onOrAfter(EsMajorVersion.V_5_X) ? index + "/_mapping/" + type : index + "/" + type;
        return this.exists(indexType);
    }

    public boolean indexExists(String index) {
        return this.exists(index);
    }

    private boolean exists(String indexOrType) {
        SimpleRequest req = new SimpleRequest(Request.Method.HEAD, null, indexOrType);
        Response res = this.executeNotFoundAllowed(req);
        return res.status() == 200;
    }

    public boolean touch(String index) {
        if (!this.indexExists(index)) {
            Response response = this.execute(Request.Method.PUT, index, false);
            if (response.hasFailed()) {
                String msg = null;
                try {
                    msg = (String)this.parseContent(response.body(), "error");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.hasText(msg) && !msg.contains("IndexAlreadyExistsException")) {
                    throw new EsHadoopIllegalStateException(msg);
                }
            }
            return response.hasSucceeded();
        }
        return false;
    }

    public long count(String indexAndType, QueryBuilder query) {
        return this.count(indexAndType, null, query);
    }

    public long count(String indexAndType, String shardId, QueryBuilder query) {
        return this.internalVersion.onOrAfter(EsMajorVersion.V_5_X) ? this.countInES5X(indexAndType, shardId, query) : this.countBeforeES5X(indexAndType, shardId, query);
    }

    private long countBeforeES5X(String indexAndType, String shardId, QueryBuilder query) {
        Response response;
        Number count;
        StringBuilder uri = new StringBuilder(indexAndType);
        uri.append("/_count");
        if (StringUtils.hasLength(shardId)) {
            uri.append("?preference=_shards:");
            uri.append(shardId);
        }
        return (count = (Number)this.parseContent((response = this.execute(Request.Method.GET, uri.toString(), RestClient.searchRequest(query))).body(), "count")) != null ? count.longValue() : -1L;
    }

    private long countInES5X(String indexAndType, String shardId, QueryBuilder query) {
        Response response;
        Map content;
        Number count;
        StringBuilder uri = new StringBuilder(indexAndType);
        uri.append("/_search?size=0");
        if (StringUtils.hasLength(shardId)) {
            uri.append("&preference=_shards:");
            uri.append(shardId);
        }
        return (count = (Number)(content = (Map)this.parseContent((response = this.execute(Request.Method.GET, uri.toString(), RestClient.searchRequest(query))).body(), "hits")).get("total")) != null ? count.longValue() : -1L;
    }

    static BytesArray searchRequest(QueryBuilder query) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(256);
        JacksonJsonGenerator generator = new JacksonJsonGenerator(out);
        try {
            generator.writeBeginObject();
            generator.writeFieldName("query");
            generator.writeBeginObject();
            query.toJson(generator);
            generator.writeEndObject();
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
        return out.bytes();
    }

    public boolean isAlias(String query) {
        Map aliases = (Map)this.get(query, null);
        return aliases.size() > 1;
    }

    public void putMapping(String index, String mapping, byte[] bytes) {
        this.touch(index);
        this.execute(Request.Method.PUT, mapping, new BytesArray(bytes));
    }

    public EsMajorVersion remoteEsVersion() {
        Map result = (Map)this.get("", "version");
        if (result == null || !StringUtils.hasText((CharSequence)result.get("number"))) {
            throw new EsHadoopIllegalStateException("Unable to retrieve elasticsearch version.");
        }
        return EsMajorVersion.parse((String)result.get("number"));
    }

    public Health getHealth(String index) {
        StringBuilder sb = new StringBuilder("/_cluster/health/");
        sb.append(index);
        String status = (String)this.get(sb.toString(), "status");
        if (status == null) {
            throw new EsHadoopIllegalStateException("Could not determine index health, returned status was null. Bailing out...");
        }
        return Health.valueOf(status.toUpperCase());
    }

    public boolean waitForHealth(String index, Health health, TimeValue timeout) {
        StringBuilder sb = new StringBuilder("/_cluster/health/");
        sb.append(index);
        sb.append("?wait_for_status=");
        sb.append(health.name().toLowerCase(Locale.ROOT));
        sb.append("&timeout=");
        sb.append(timeout.toString());
        return Boolean.TRUE.equals(this.get(sb.toString(), "timed_out"));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.network != null) {
            copy.aggregate(this.network.stats());
        }
        return copy;
    }

    private void countStreamStats(InputStream content) {
        if (content instanceof StatsAware) {
            this.stats.aggregate(((StatsAware)((Object)content)).stats());
        }
    }

    public String getCurrentNode() {
        return this.network.currentNode();
    }

    public static class BulkActionResponse {
        private Iterator<Map> entries;
        private long timeSpent;
        private int responseCode;

        public BulkActionResponse(Iterator<Map> entries, int responseCode, long timeSpent) {
            this.entries = entries;
            this.timeSpent = timeSpent;
            this.responseCode = responseCode;
        }

        public Iterator<Map> getEntries() {
            return this.entries;
        }

        public long getTimeSpent() {
            return this.timeSpent;
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }

    public static enum Health {
        RED,
        YELLOW,
        GREEN;

    }
}

