/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.BytesRef;
import org.elasticsearch.hadoop.util.StringUtils;

public class TrackingBytesArray
implements ByteSequence {
    private final BytesArray data;
    private int maxEntries = 0;
    private int size = 0;
    private List<Entry> entries = new LinkedList<Entry>();

    public TrackingBytesArray(BytesArray data) {
        this.data = data;
    }

    public void copyFrom(BytesArray from) {
        this.addEntry(from.size);
        from.copyTo(this.data);
    }

    public void copyFrom(BytesRef from) {
        this.addEntry(from.length());
        from.copyTo(this.data);
    }

    @Override
    public int length() {
        return this.size;
    }

    public int entries() {
        return this.entries.size();
    }

    public BitSet leftoversPosition() {
        BitSet bitSet = new BitSet(this.maxEntries);
        for (Entry entry : this.entries) {
            bitSet.set(entry.initialPosition);
        }
        return bitSet;
    }

    private void addEntry(int length) {
        this.entries.add(new Entry(this.data.size, length, this.entries.size()));
        this.size += length;
        this.maxEntries = this.size;
    }

    public void remove(int index) {
        Entry entry = this.entries.remove(index);
        this.size -= entry.length;
    }

    public BytesArray entry(int index) {
        Entry entry = this.entries.get(index);
        return new BytesArray(this.data.bytes, entry.offset, entry.length);
    }

    public BytesArray pop() {
        Entry entry = this.entries.remove(0);
        this.size -= entry.length;
        byte[] entryData = new byte[entry.length];
        System.arraycopy(this.data.bytes(), entry.offset, entryData, 0, entry.length);
        return new BytesArray(entryData, entry.length);
    }

    public int length(int index) {
        return this.entries.get((int)index).length;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (this.size == 0) {
            return;
        }
        for (Entry entry : this.entries) {
            out.write(this.data.bytes, entry.offset, entry.length);
        }
        out.flush();
    }

    public void reset() {
        this.size = 0;
        this.maxEntries = 0;
        this.entries.clear();
        this.data.reset();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        for (Entry entry : this.entries) {
            sb.append(new String(this.data.bytes, entry.offset, entry.length, StringUtils.UTF_8));
        }
        return sb.toString();
    }

    private static class Entry {
        final int offset;
        final int length;
        final int initialPosition;

        Entry(int offset, int length, int initialPosition) {
            this.offset = offset;
            this.length = length;
            this.initialPosition = initialPosition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.offset;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.offset == other.offset;
        }
    }
}

