/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.bulk.JsonTemplatedBulk;
import org.elasticsearch.hadoop.serialization.field.JsonFieldExtractors;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

class JsonScriptTemplateBulk
extends JsonTemplatedBulk {
    private static final Log log = LogFactory.getLog(JsonTemplatedBulk.class);
    private final BytesArray scratchPad = new BytesArray(1024);

    public JsonScriptTemplateBulk(Collection<Object> beforeObject, Collection<Object> afterObject, JsonFieldExtractors jsonExtractors, Settings settings) {
        super(beforeObject, afterObject, jsonExtractors, settings);
    }

    @Override
    protected Object preProcess(Object object, BytesArray storage) {
        Assert.notNull(object, "Empty/null JSON document given...");
        BytesArray ba = null;
        if ("upsert".equals(this.settings.getOperation())) {
            ba = storage;
            if (this.settings.hasScriptUpsert()) {
                this.jsonWriter.convert("{}", ba);
                this.scratchPad.reset();
                ba = this.scratchPad;
            }
        } else {
            this.scratchPad.reset();
            ba = this.scratchPad;
        }
        this.jsonWriter.convert(object, ba);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("About to extract information from [%s]", ba));
        }
        this.jsonExtractors.process(ba);
        return storage;
    }
}

