/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.deletebyquery;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.deletebyquery.DeleteByQueryAction;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestDeleteByQueryAction
extends BaseRestHandler {
    @Inject
    public RestDeleteByQueryAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/_query", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.DELETE, "/{index}/{type}/_query", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        DeleteByQueryRequest delete = new DeleteByQueryRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        delete.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)delete.indicesOptions()));
        delete.routing(request.param("routing"));
        if (request.hasParam("timeout")) {
            delete.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasContent()) {
            delete.source(request.content());
        } else {
            String source = request.param("source");
            if (source != null) {
                delete.source(source);
            } else {
                QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource((RestRequest)request);
                if (querySourceBuilder != null) {
                    delete.source(querySourceBuilder);
                }
            }
        }
        delete.types(Strings.splitStringByCommaToArray((String)request.param("type")));
        client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)delete, (ActionListener)new RestToXContentListener(channel));
    }
}

