/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.mapper.attachments;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.metadata.Metadata;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.mapper.attachments.TikaImpl;

public class AttachmentMapper
extends FieldMapper {
    private static ESLogger logger = ESLoggerFactory.getLogger((String)"mapper.attachment");
    public static final String CONTENT_TYPE = "attachment";
    private final ContentPath.Type pathType;
    private final int defaultIndexedChars;
    private final boolean ignoreErrors;
    private final boolean defaultLangDetect;
    private final FieldMapper contentMapper;
    private final FieldMapper dateMapper;
    private final FieldMapper authorMapper;
    private final FieldMapper titleMapper;
    private final FieldMapper nameMapper;
    private final FieldMapper keywordsMapper;
    private final FieldMapper contentTypeMapper;
    private final FieldMapper contentLengthMapper;
    private final FieldMapper languageMapper;

    public AttachmentMapper(String simpleName, MappedFieldType type, MappedFieldType defaultFieldType, ContentPath.Type pathType, int defaultIndexedChars, Boolean ignoreErrors, Boolean defaultLangDetect, FieldMapper contentMapper, FieldMapper dateMapper, FieldMapper titleMapper, FieldMapper nameMapper, FieldMapper authorMapper, FieldMapper keywordsMapper, FieldMapper contentTypeMapper, FieldMapper contentLengthMapper, FieldMapper languageMapper, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, type, defaultFieldType, indexSettings, multiFields, copyTo);
        this.pathType = pathType;
        this.defaultIndexedChars = defaultIndexedChars;
        this.ignoreErrors = ignoreErrors;
        this.defaultLangDetect = defaultLangDetect;
        this.contentMapper = contentMapper;
        this.dateMapper = dateMapper;
        this.titleMapper = titleMapper;
        this.nameMapper = nameMapper;
        this.authorMapper = authorMapper;
        this.keywordsMapper = keywordsMapper;
        this.contentTypeMapper = contentTypeMapper;
        this.contentLengthMapper = contentLengthMapper;
        this.languageMapper = languageMapper;
    }

    public Mapper parse(ParseContext context) throws IOException {
        block55: {
            Metadata metadata;
            byte[] content;
            block54: {
                String contentType;
                block53: {
                    block52: {
                        block51: {
                            block50: {
                                block49: {
                                    String parsedContent;
                                    content = null;
                                    contentType = null;
                                    int indexedChars = this.defaultIndexedChars;
                                    boolean langDetect = this.defaultLangDetect;
                                    String name = null;
                                    String language = null;
                                    XContentParser parser = context.parser();
                                    XContentParser.Token token = parser.currentToken();
                                    if (token == XContentParser.Token.VALUE_STRING) {
                                        content = parser.binaryValue();
                                    } else {
                                        String currentFieldName = null;
                                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                            if (token == XContentParser.Token.FIELD_NAME) {
                                                currentFieldName = parser.currentName();
                                                continue;
                                            }
                                            if (token == XContentParser.Token.VALUE_STRING) {
                                                if ("_content".equals(currentFieldName)) {
                                                    content = parser.binaryValue();
                                                    continue;
                                                }
                                                if ("_content_type".equals(currentFieldName)) {
                                                    contentType = parser.text();
                                                    continue;
                                                }
                                                if ("_name".equals(currentFieldName)) {
                                                    name = parser.text();
                                                    continue;
                                                }
                                                if (!"_language".equals(currentFieldName)) continue;
                                                language = parser.text();
                                                continue;
                                            }
                                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                                if (!"_indexed_chars".equals(currentFieldName) && !"_indexedChars".equals(currentFieldName)) continue;
                                                indexedChars = parser.intValue();
                                                continue;
                                            }
                                            if (token != XContentParser.Token.VALUE_BOOLEAN || !"_detect_language".equals(currentFieldName) && !"_detectLanguage".equals(currentFieldName)) continue;
                                            langDetect = parser.booleanValue();
                                        }
                                    }
                                    if (content == null) {
                                        throw new MapperParsingException("No content is provided.");
                                    }
                                    metadata = new Metadata();
                                    if (contentType != null) {
                                        metadata.add("Content-Type", contentType);
                                    }
                                    if (name != null) {
                                        metadata.add("resourceName", name);
                                    }
                                    try {
                                        parsedContent = TikaImpl.parse(content, metadata, indexedChars);
                                    }
                                    catch (Throwable e) {
                                        if (!this.ignoreErrors) {
                                            logger.trace("exception caught", e, new Object[0]);
                                            throw new MapperParsingException("Failed to extract [" + indexedChars + "] characters of text for [" + name + "] : " + e.getMessage(), e);
                                        }
                                        logger.debug("Failed to extract [{}] characters of text for [{}]: [{}]", new Object[]{indexedChars, name, e.getMessage()});
                                        logger.trace("exception caught", e, new Object[0]);
                                        return null;
                                    }
                                    context = context.createExternalValueContext((Object)parsedContent);
                                    this.contentMapper.parse(context);
                                    if (langDetect) {
                                        try {
                                            if (language != null) {
                                                metadata.add("Content-Language", language);
                                            } else {
                                                LanguageIdentifier identifier = new LanguageIdentifier(parsedContent);
                                                language = identifier.getLanguage();
                                            }
                                            context = context.createExternalValueContext((Object)language);
                                            this.languageMapper.parse(context);
                                        }
                                        catch (Throwable t) {
                                            logger.debug("Cannot detect language: [{}]", new Object[]{t.getMessage()});
                                        }
                                    }
                                    if (name != null) {
                                        try {
                                            context = context.createExternalValueContext((Object)name);
                                            this.nameMapper.parse(context);
                                        }
                                        catch (MapperParsingException e) {
                                            if (!this.ignoreErrors) {
                                                throw e;
                                            }
                                            if (!logger.isDebugEnabled()) break block49;
                                            logger.debug("Ignoring MapperParsingException catch while parsing name: [{}]", new Object[]{e.getMessage()});
                                        }
                                    }
                                }
                                if (metadata.get(Metadata.DATE) != null) {
                                    try {
                                        context = context.createExternalValueContext((Object)metadata.get(Metadata.DATE));
                                        this.dateMapper.parse(context);
                                    }
                                    catch (MapperParsingException e) {
                                        if (!this.ignoreErrors) {
                                            throw e;
                                        }
                                        if (!logger.isDebugEnabled()) break block50;
                                        logger.debug("Ignoring MapperParsingException catch while parsing date: [{}]: [{}]", new Object[]{e.getMessage(), context.externalValue()});
                                    }
                                }
                            }
                            if (metadata.get("title") != null) {
                                try {
                                    context = context.createExternalValueContext((Object)metadata.get("title"));
                                    this.titleMapper.parse(context);
                                }
                                catch (MapperParsingException e) {
                                    if (!this.ignoreErrors) {
                                        throw e;
                                    }
                                    if (!logger.isDebugEnabled()) break block51;
                                    logger.debug("Ignoring MapperParsingException catch while parsing title: [{}]: [{}]", new Object[]{e.getMessage(), context.externalValue()});
                                }
                            }
                        }
                        if (metadata.get("Author") != null) {
                            try {
                                context = context.createExternalValueContext((Object)metadata.get("Author"));
                                this.authorMapper.parse(context);
                            }
                            catch (MapperParsingException e) {
                                if (!this.ignoreErrors) {
                                    throw e;
                                }
                                if (!logger.isDebugEnabled()) break block52;
                                logger.debug("Ignoring MapperParsingException catch while parsing author: [{}]: [{}]", new Object[]{e.getMessage(), context.externalValue()});
                            }
                        }
                    }
                    if (metadata.get("Keywords") != null) {
                        try {
                            context = context.createExternalValueContext((Object)metadata.get("Keywords"));
                            this.keywordsMapper.parse(context);
                        }
                        catch (MapperParsingException e) {
                            if (!this.ignoreErrors) {
                                throw e;
                            }
                            if (!logger.isDebugEnabled()) break block53;
                            logger.debug("Ignoring MapperParsingException catch while parsing keywords: [{}]: [{}]", new Object[]{e.getMessage(), context.externalValue()});
                        }
                    }
                }
                if (contentType == null) {
                    contentType = metadata.get("Content-Type");
                }
                if (contentType != null) {
                    try {
                        context = context.createExternalValueContext((Object)contentType);
                        this.contentTypeMapper.parse(context);
                    }
                    catch (MapperParsingException e) {
                        if (!this.ignoreErrors) {
                            throw e;
                        }
                        if (!logger.isDebugEnabled()) break block54;
                        logger.debug("Ignoring MapperParsingException catch while parsing content_type: [{}]: [{}]", new Object[]{e.getMessage(), context.externalValue()});
                    }
                }
            }
            int length = content.length;
            if (metadata.get("Content-Length") != null) {
                length = Integer.parseInt(metadata.get("Content-Length"));
            }
            try {
                context = context.createExternalValueContext((Object)length);
                this.contentLengthMapper.parse(context);
            }
            catch (MapperParsingException e) {
                if (!this.ignoreErrors) {
                    throw e;
                }
                if (!logger.isDebugEnabled()) break block55;
                logger.debug("Ignoring MapperParsingException catch while parsing content_length: [{}]: [{}]", new Object[]{e.getMessage(), context.externalValue()});
            }
        }
        return null;
    }

    protected void parseCreateField(ParseContext parseContext, List<Field> fields) throws IOException {
    }

    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    public Iterator<Mapper> iterator() {
        List<FieldMapper> extras = Arrays.asList(this.contentMapper, this.dateMapper, this.titleMapper, this.nameMapper, this.authorMapper, this.keywordsMapper, this.contentTypeMapper, this.contentLengthMapper, this.languageMapper);
        return Iterators.concat((Iterator)super.iterator(), extras.iterator());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        builder.field("type", CONTENT_TYPE);
        if (this.indexCreatedBefore2x) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("fields");
        this.contentMapper.toXContent(builder, params);
        this.authorMapper.toXContent(builder, params);
        this.titleMapper.toXContent(builder, params);
        this.nameMapper.toXContent(builder, params);
        this.dateMapper.toXContent(builder, params);
        this.keywordsMapper.toXContent(builder, params);
        this.contentTypeMapper.toXContent(builder, params);
        this.contentLengthMapper.toXContent(builder, params);
        this.languageMapper.toXContent(builder, params);
        this.multiFields.toXContent(builder, params);
        builder.endObject();
        this.multiFields.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private Mapper.Builder<?, ?> findMapperBuilder(Map<String, Object> propNode, String propName, Mapper.TypeParser.ParserContext parserContext) {
            Object typeNode = propNode.get("type");
            String type = typeNode != null ? typeNode.toString() : "string";
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            Mapper.Builder mapperBuilder = typeParser.parse(propName, propNode, parserContext);
            return mapperBuilder;
        }

        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    builder.pathType(TypeParsers.parsePathType((String)name, (String)fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("fields")) continue;
                Map fieldsNode = (Map)fieldNode;
                Iterator fieldsIterator = fieldsNode.entrySet().iterator();
                while (fieldsIterator.hasNext()) {
                    Map.Entry entry1 = fieldsIterator.next();
                    String propName = (String)entry1.getKey();
                    Map propNode = (Map)entry1.getValue();
                    Mapper.Builder<?, ?> mapperBuilder = this.findMapperBuilder(propNode, propName, parserContext);
                    if (TypeParsers.parseMultiField((FieldMapper.Builder)((FieldMapper.Builder)mapperBuilder), (String)fieldName, (Mapper.TypeParser.ParserContext)parserContext, (String)propName, (Object)propNode)) {
                        fieldsIterator.remove();
                        continue;
                    }
                    if (propName.equals(name) && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                        builder.content(mapperBuilder);
                        fieldsIterator.remove();
                        continue;
                    }
                    switch (propName) {
                        case "content": {
                            builder.content(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "date": {
                            builder.date(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "author": {
                            builder.author(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "content_length": {
                            builder.contentLength(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "content_type": {
                            builder.contentType(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "keywords": {
                            builder.keywords(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "language": {
                            builder.language(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "title": {
                            builder.title(mapperBuilder);
                            fieldsIterator.remove();
                            break;
                        }
                        case "name": {
                            builder.name(mapperBuilder);
                            fieldsIterator.remove();
                        }
                    }
                }
                DocumentMapperParser.checkNoRemainingFields((String)fieldName, (Map)fieldsNode, (Version)parserContext.indexVersionCreated());
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, AttachmentMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private Boolean ignoreErrors = null;
        private Integer defaultIndexedChars = null;
        private Boolean langDetect = null;
        private Mapper.Builder contentBuilder;
        private Mapper.Builder titleBuilder = MapperBuilders.stringField((String)"title");
        private Mapper.Builder nameBuilder = MapperBuilders.stringField((String)"name");
        private Mapper.Builder authorBuilder = MapperBuilders.stringField((String)"author");
        private Mapper.Builder keywordsBuilder = MapperBuilders.stringField((String)"keywords");
        private Mapper.Builder dateBuilder = MapperBuilders.dateField((String)"date");
        private Mapper.Builder contentTypeBuilder = MapperBuilders.stringField((String)"content_type");
        private Mapper.Builder contentLengthBuilder = MapperBuilders.integerField((String)"content_length");
        private Mapper.Builder languageBuilder = MapperBuilders.stringField((String)"language");

        public Builder(String name) {
            super(name, (MappedFieldType)new AttachmentFieldType(), (MappedFieldType)new AttachmentFieldType());
            this.builder = this;
            this.contentBuilder = MapperBuilders.stringField((String)"content");
        }

        public Builder pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder content(Mapper.Builder content) {
            this.contentBuilder = content;
            return this;
        }

        public Builder date(Mapper.Builder date) {
            this.dateBuilder = date;
            return this;
        }

        public Builder author(Mapper.Builder author) {
            this.authorBuilder = author;
            return this;
        }

        public Builder title(Mapper.Builder title) {
            this.titleBuilder = title;
            return this;
        }

        public Builder name(Mapper.Builder name) {
            this.nameBuilder = name;
            return this;
        }

        public Builder keywords(Mapper.Builder keywords) {
            this.keywordsBuilder = keywords;
            return this;
        }

        public Builder contentType(Mapper.Builder contentType) {
            this.contentTypeBuilder = contentType;
            return this;
        }

        public Builder contentLength(Mapper.Builder contentType) {
            this.contentLengthBuilder = contentType;
            return this;
        }

        public Builder language(Mapper.Builder language) {
            this.languageBuilder = language;
            return this;
        }

        public AttachmentMapper build(Mapper.BuilderContext context) {
            FieldMapper contentMapper;
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            if (context.indexCreatedVersion().before(Version.V_2_0_0_beta1)) {
                if (!(this.contentBuilder instanceof FieldMapper.Builder)) {
                    throw new IllegalStateException("content field for attachment must be a field mapper");
                }
                ((FieldMapper.Builder)this.contentBuilder).indexName(this.name);
                this.contentBuilder.name = this.name + "." + "content";
                contentMapper = (FieldMapper)this.contentBuilder.build(context);
                context.path().add(this.name);
            } else {
                context.path().add(this.name);
                contentMapper = (FieldMapper)this.contentBuilder.build(context);
            }
            FieldMapper dateMapper = (FieldMapper)this.dateBuilder.build(context);
            FieldMapper authorMapper = (FieldMapper)this.authorBuilder.build(context);
            FieldMapper titleMapper = (FieldMapper)this.titleBuilder.build(context);
            FieldMapper nameMapper = (FieldMapper)this.nameBuilder.build(context);
            FieldMapper keywordsMapper = (FieldMapper)this.keywordsBuilder.build(context);
            FieldMapper contentTypeMapper = (FieldMapper)this.contentTypeBuilder.build(context);
            FieldMapper contentLength = (FieldMapper)this.contentLengthBuilder.build(context);
            FieldMapper language = (FieldMapper)this.languageBuilder.build(context);
            context.path().remove();
            context.path().pathType(origPathType);
            if (this.defaultIndexedChars == null && context.indexSettings() != null) {
                this.defaultIndexedChars = context.indexSettings().getAsInt("index.mapping.attachment.indexed_chars", Integer.valueOf(100000));
            }
            if (this.defaultIndexedChars == null) {
                this.defaultIndexedChars = 100000;
            }
            if (this.ignoreErrors == null && context.indexSettings() != null) {
                this.ignoreErrors = context.indexSettings().getAsBoolean("index.mapping.attachment.ignore_errors", Boolean.TRUE);
            }
            if (this.ignoreErrors == null) {
                this.ignoreErrors = Boolean.TRUE;
            }
            if (this.langDetect == null && context.indexSettings() != null) {
                this.langDetect = context.indexSettings().getAsBoolean("index.mapping.attachment.detect_language", Boolean.FALSE);
            }
            if (this.langDetect == null) {
                this.langDetect = Boolean.FALSE;
            }
            AttachmentFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
            if (this.fieldType.indexOptions() != IndexOptions.NONE && !this.fieldType.tokenized()) {
                defaultFieldType.setOmitNorms(true);
                defaultFieldType.setIndexOptions(IndexOptions.DOCS);
                if (!this.omitNormsSet && this.fieldType.boost() == 1.0f) {
                    this.fieldType.setOmitNorms(true);
                }
                if (!this.indexOptionsSet) {
                    this.fieldType.setIndexOptions(IndexOptions.DOCS);
                }
            }
            defaultFieldType.freeze();
            this.setupFieldType(context);
            return new AttachmentMapper(this.name, this.fieldType, defaultFieldType, this.pathType, this.defaultIndexedChars, this.ignoreErrors, this.langDetect, contentMapper, dateMapper, titleMapper, nameMapper, authorMapper, keywordsMapper, contentTypeMapper, contentLength, language, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    static final class AttachmentFieldType
    extends MappedFieldType {
        public AttachmentFieldType() {
        }

        protected AttachmentFieldType(AttachmentFieldType ref) {
            super((MappedFieldType)ref);
        }

        public AttachmentFieldType clone() {
            return new AttachmentFieldType(this);
        }

        public String typeName() {
            return AttachmentMapper.CONTENT_TYPE;
        }

        public String value(Object value) {
            return value == null ? null : value.toString();
        }
    }

    public static class FieldNames {
        public static final String CONTENT = "content";
        public static final String TITLE = "title";
        public static final String NAME = "name";
        public static final String AUTHOR = "author";
        public static final String KEYWORDS = "keywords";
        public static final String DATE = "date";
        public static final String CONTENT_TYPE = "content_type";
        public static final String CONTENT_LENGTH = "content_length";
        public static final String LANGUAGE = "language";
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
        public static final AttachmentFieldType FIELD_TYPE = new AttachmentFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

