/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ParentBulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkingBulkByScrollTask;
import org.elasticsearch.index.reindex.remote.RemoteScrollableHitSource;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, BulkByScrollResponse> {
    public static final Setting<List<String>> REMOTE_CLUSTER_WHITELIST = Setting.listSetting((String)"reindex.remote.whitelist", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final AutoCreateIndex autoCreateIndex;
    private final Client client;
    private final CharacterRunAutomaton remoteWhitelist;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService) {
        super(settings, "indices:data/write/reindex", threadPool, transportService, actionFilters, indexNameExpressionResolver, ReindexRequest::new);
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
        this.remoteWhitelist = TransportReindexAction.buildRemoteWhitelist((List)REMOTE_CLUSTER_WHITELIST.get(settings));
    }

    protected void doExecute(Task task, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
        if (request.getSlices() > 1) {
            BulkByScrollParallelizationHelper.startSlices(this.client, this.taskManager, ReindexAction.INSTANCE, this.clusterService.localNode().getId(), (ParentBulkByScrollTask)task, request, listener);
        } else {
            TransportReindexAction.checkRemoteWhitelist(this.remoteWhitelist, request.getRemoteInfo());
            ClusterState state = this.clusterService.state();
            TransportReindexAction.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), request.getRemoteInfo(), this.indexNameExpressionResolver, this.autoCreateIndex, state);
            ParentTaskAssigningClient client = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
            new AsyncIndexBySearchAction((WorkingBulkByScrollTask)task, this.logger, client, this.threadPool, request, this.scriptService, state, listener).start();
        }
    }

    protected void doExecute(ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static void checkRemoteWhitelist(CharacterRunAutomaton whitelist, RemoteInfo remoteInfo) {
        if (remoteInfo == null) {
            return;
        }
        String check = remoteInfo.getHost() + ':' + remoteInfo.getPort();
        if (whitelist.run(check)) {
            return;
        }
        throw new IllegalArgumentException('[' + check + "] not whitelisted in " + REMOTE_CLUSTER_WHITELIST.getKey());
    }

    static CharacterRunAutomaton buildRemoteWhitelist(List<String> whitelist) {
        if (whitelist.isEmpty()) {
            return new CharacterRunAutomaton(Automata.makeEmpty());
        }
        Automaton automaton = Regex.simpleMatchToAutomaton((String[])whitelist.toArray(Strings.EMPTY_ARRAY));
        if (Operations.isTotal((Automaton)(automaton = MinimizationOperations.minimize((Automaton)automaton, (int)10000)))) {
            throw new IllegalArgumentException("Refusing to start because whitelist " + whitelist + " accepts all addresses. This would allow users to reindex-from-remote any URL they like effectively having Elasticsearch make HTTP GETs for them.");
        }
        return new CharacterRunAutomaton(automaton);
    }

    static void validateAgainstAliases(SearchRequest source, IndexRequest destination, RemoteInfo remoteInfo, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ClusterState clusterState) {
        if (remoteInfo != null) {
            return;
        }
        String target = destination.index();
        if (!autoCreateIndex.shouldAutoCreate(target, clusterState)) {
            target = indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)destination)[0];
        }
        for (String sourceIndex : indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)source)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + ']');
            throw e;
        }
    }

    static RestClient buildRestClient(RemoteInfo remoteInfo, long taskId, List<Thread> threadCollector) {
        Header[] clientHeaders = new Header[remoteInfo.getHeaders().size()];
        int i = 0;
        for (Map.Entry header : remoteInfo.getHeaders().entrySet()) {
            clientHeaders[i] = new BasicHeader((String)header.getKey(), (String)header.getValue());
        }
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(remoteInfo.getHost(), remoteInfo.getPort(), remoteInfo.getScheme())}).setDefaultHeaders(clientHeaders).setRequestConfigCallback(c -> {
            c.setConnectTimeout(Math.toIntExact(remoteInfo.getConnectTimeout().millis()));
            c.setSocketTimeout(Math.toIntExact(remoteInfo.getSocketTimeout().millis()));
            return c;
        }).setHttpClientConfigCallback(c -> {
            if (remoteInfo.getUsername() != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(remoteInfo.getUsername(), remoteInfo.getPassword());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
                c.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            AtomicInteger threads = new AtomicInteger();
            c.setThreadFactory(r -> {
                String name = "es-client-" + taskId + "-" + threads.getAndIncrement();
                Thread t = new Thread(r, name);
                threadCollector.add(t);
                return t;
            });
            c.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
            return c;
        }).build();
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<ReindexRequest> {
        private List<Thread> createdThreads = Collections.emptyList();

        AsyncIndexBySearchAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ReindexRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
            this(task, logger, client, threadPool, request, scriptService, clusterState, listener, client.settings());
        }

        AsyncIndexBySearchAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ReindexRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener, Settings settings) {
            super(task, logger, client, threadPool, request, scriptService, clusterState, listener, settings);
        }

        @Override
        protected boolean needsSourceDocumentVersions() {
            return ((ReindexRequest)this.mainRequest).getDestination().versionType() != VersionType.INTERNAL;
        }

        @Override
        protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
            if (((ReindexRequest)this.mainRequest).getRemoteInfo() != null) {
                RemoteInfo remoteInfo = ((ReindexRequest)this.mainRequest).getRemoteInfo();
                this.createdThreads = Collections.synchronizedList(new ArrayList());
                RestClient restClient = TransportReindexAction.buildRestClient(remoteInfo, this.task.getId(), this.createdThreads);
                return new RemoteScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkingBulkByScrollTask)this.task).countSearchRetry(), this::finishHim, restClient, remoteInfo.getQuery(), ((ReindexRequest)this.mainRequest).getSearchRequest());
            }
            return super.buildScrollableResultSource(backoffPolicy);
        }

        @Override
        protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
            super.finishHim(failure, indexingFailures, searchFailures, timedOut);
            for (Thread thread : this.createdThreads) {
                if (!thread.isAlive()) continue;
                assert (false) : "Failed to properly stop client thread [" + thread.getName() + "]";
                this.logger.error("Failed to properly stop client thread [{}]", (Object)thread.getName());
            }
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((ReindexRequest)this.mainRequest).getScript();
            if (script != null) {
                return new ReindexScriptApplier(this.task, this.scriptService, script, (Map<String, Object>)script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index;
            block32: {
                index = new IndexRequest();
                index.index(((ReindexRequest)this.mainRequest).getDestination().index());
                if (((ReindexRequest)this.mainRequest).getDestination().type() == null) {
                    index.type(doc.getType());
                } else {
                    index.type(((ReindexRequest)this.mainRequest).getDestination().type());
                }
                index.versionType(((ReindexRequest)this.mainRequest).getDestination().versionType());
                if (index.versionType() == VersionType.INTERNAL) {
                    assert (doc.getVersion() == -1L) : "fetched version when we didn't have to";
                    index.version(((ReindexRequest)this.mainRequest).getDestination().version());
                } else {
                    index.version(doc.getVersion());
                }
                index.id(doc.getId());
                XContentType sourceXContentType = doc.getXContentType();
                XContentType mainRequestXContentType = ((ReindexRequest)this.mainRequest).getDestination().getContentType();
                if (mainRequestXContentType != null && doc.getXContentType() != mainRequestXContentType) {
                    try (XContentParser parser = sourceXContentType.xContent().createParser(NamedXContentRegistry.EMPTY, doc.getSource());
                         XContentBuilder builder = XContentBuilder.builder((XContent)mainRequestXContentType.xContent());){
                        parser.nextToken();
                        builder.copyCurrentStructure(parser);
                        index.source(builder.bytes(), builder.contentType());
                        break block32;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to convert hit from " + sourceXContentType + " to " + mainRequestXContentType, e);
                    }
                }
                index.source(doc.getSource(), doc.getXContentType());
            }
            index.routing(((ReindexRequest)this.mainRequest).getDestination().routing());
            index.parent(((ReindexRequest)this.mainRequest).getDestination().parent());
            index.timestamp(((ReindexRequest)this.mainRequest).getDestination().timestamp());
            index.ttl(((ReindexRequest)this.mainRequest).getDestination().ttl());
            index.setPipeline(((ReindexRequest)this.mainRequest).getDestination().getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        @Override
        protected void copyRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, String routing) {
            String routingSpec = ((ReindexRequest)this.mainRequest).getDestination().routing();
            if (routingSpec == null) {
                super.copyRouting(request, routing);
                return;
            }
            if (routingSpec.startsWith("=")) {
                super.copyRouting(request, ((ReindexRequest)this.mainRequest).getDestination().routing().substring(1));
                return;
            }
            switch (routingSpec) {
                case "keep": {
                    super.copyRouting(request, routing);
                    break;
                }
                case "discard": {
                    super.copyRouting(request, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported routing command");
                }
            }
        }

        class ReindexScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            ReindexScriptApplier(WorkingBulkByScrollTask task, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(AsyncIndexBySearchAction.this, task, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                Objects.requireNonNull(to, "Can't reindex without a destination index!");
                request.setIndex(to.toString());
            }

            @Override
            protected void scriptChangedType(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                Objects.requireNonNull(to, "Can't reindex without a destination type!");
                request.setType(to.toString());
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setId(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                if (to == null) {
                    request.setVersion(-3L);
                    request.setVersionType(VersionType.INTERNAL);
                } else {
                    request.setVersion(this.asLong(to, "_version"));
                }
            }

            @Override
            protected void scriptChangedParent(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                String routing = Objects.toString(to, null);
                request.setParent(routing);
                request.setRouting(routing);
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setRouting(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedTimestamp(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setTimestamp(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedTTL(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                if (to == null) {
                    request.setTtl(null);
                } else {
                    request.setTtl(this.asLong(to, "_ttl"));
                }
            }

            private long asLong(Object from, String name) {
                Number fromNumber;
                try {
                    fromNumber = (Number)from;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]", e);
                }
                long l = fromNumber.longValue();
                if (fromNumber.doubleValue() != (double)l) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]");
                }
                return l;
            }
        }
    }
}

