/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.ESTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class ESRestTestCase
extends ESTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;

    public Map<String, Object> entityAsMap(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = this.createParser(xContentType.xContent(), response.getEntity().getContent());){
            Map map = parser.map();
            return map;
        }
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            String cluster = System.getProperty("tests.rest.cluster");
            if (cluster == null) {
                throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
            }
            String[] stringUrls = cluster.split(",");
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
            for (String stringUrl : stringUrls) {
                int portSeparator = stringUrl.lastIndexOf(58);
                if (portSeparator < 0) {
                    throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
                }
                String host = stringUrl.substring(0, portSeparator);
                int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
                hosts.add(new HttpHost(host, port, this.getProtocol()));
            }
            clusterHosts = Collections.unmodifiableList(hosts);
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings());
            adminClient = this.buildClient(this.restAdminSettings());
        }
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
    }

    @After
    public final void cleanUpCluster() throws Exception {
        this.wipeCluster();
        this.logIfThereAreRunningTasks();
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    private void wipeCluster() throws IOException {
        block4: {
            if (!this.preserveIndicesUponCompletion()) {
                try {
                    ESRestTestCase.adminClient().performRequest("DELETE", "*", new Header[0]);
                }
                catch (ResponseException e) {
                    if (e.getResponse().getStatusLine().getStatusCode() == 404) break block4;
                    throw e;
                }
            }
        }
        if (!this.preserveTemplatesUponCompletion()) {
            ESRestTestCase.adminClient().performRequest("DELETE", "_template/*", new Header[0]);
        }
        this.wipeSnapshots();
    }

    private void wipeSnapshots() throws IOException {
        for (Map.Entry<String, Object> repo : this.entityAsMap(adminClient.performRequest("GET", "_snapshot/_all", new Header[0])).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (repoType.equals("fs")) {
                String url = "_snapshot/" + repoName + "/_all";
                Map<String, String> params = Collections.singletonMap("ignore_unavailable", "true");
                List snapshots = (List)this.entityAsMap(adminClient.performRequest("GET", url, params, new Header[0])).get("snapshots");
                for (Object snapshot : snapshots) {
                    Map snapshotInfo = (Map)snapshot;
                    String name = (String)snapshotInfo.get("snapshot");
                    this.logger.debug("wiping snapshot [{}/{}]", (Object)repoName, (Object)name);
                    ESRestTestCase.adminClient().performRequest("DELETE", "_snapshot/" + repoName + "/" + name, new Header[0]);
                }
            }
            if (this.preserveReposUponCompletion()) continue;
            this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
            ESRestTestCase.adminClient().performRequest("DELETE", "_snapshot/" + repoName, new Header[0]);
        }
    }

    private void logIfThereAreRunningTasks() throws InterruptedException, IOException {
        Set<String> runningTasks = this.runningTasks(ESRestTestCase.adminClient().performRequest("GET", "_tasks", new Header[0]));
        runningTasks.remove("cluster:monitor/tasks/lists");
        runningTasks.remove("cluster:monitor/tasks/lists[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    protected Settings restClientSettings() {
        return Settings.EMPTY;
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    private RestClient buildClient(Settings settings) throws IOException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
        String keystorePath = settings.get(TRUSTSTORE_PATH);
        if (keystorePath != null) {
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            Path path = PathUtils.get((String)keystorePath, (String[])new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance("jks");
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                Object object = null;
                try {
                    keyStore.load(is, keystorePass.toCharArray());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        try (ThreadContext threadContext = new ThreadContext(settings);){
            Header[] defaultHeaders = new Header[threadContext.getHeaders().size()];
            int i = 0;
            for (Map.Entry entry : threadContext.getHeaders().entrySet()) {
                defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
            }
            builder.setDefaultHeaders(defaultHeaders);
        }
        return builder.build();
    }

    private Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)this.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }
}

