/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.rest.yaml.ObjectPath;
import org.elasticsearch.test.rest.yaml.Stash;

public class ClientYamlTestResponse {
    private final Response response;
    private final String body;
    private ObjectPath parsedResponse;

    ClientYamlTestResponse(Response response) throws IOException {
        this.response = response;
        if (response.getEntity() != null) {
            try {
                this.body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new RuntimeException(e);
            }
        } else {
            this.body = null;
        }
        this.parseResponseBody();
    }

    private void parseResponseBody() throws IOException {
        String contentType;
        XContentType xContentType;
        if (this.body != null && ((xContentType = XContentType.fromMediaTypeOrFormat((String)(contentType = this.response.getHeader("Content-Type")))) == XContentType.JSON || xContentType == XContentType.YAML)) {
            this.parsedResponse = ObjectPath.createFromXContent(xContentType.xContent(), this.body);
        }
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public List<String> getWarningHeaders() {
        ArrayList<String> warningHeaders = new ArrayList<String>();
        for (Header header : this.response.getHeaders()) {
            if (!header.getName().equals("Warning")) continue;
            warningHeaders.add(header.getValue());
        }
        return warningHeaders;
    }

    public Object getBody() throws IOException {
        if (this.parsedResponse != null) {
            return this.parsedResponse.evaluate("");
        }
        return this.body;
    }

    public String getBodyAsString() {
        return this.body;
    }

    public boolean isError() {
        return this.response.getStatusLine().getStatusCode() >= 400;
    }

    public Object evaluate(String path) throws IOException {
        return this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) throws IOException {
        if (this.response == null) {
            return null;
        }
        if (this.parsedResponse == null) {
            if ("".equals(path) && "HEAD".equals(this.response.getRequestLine().getMethod())) {
                return !this.isError();
            }
            return null;
        }
        return this.parsedResponse.evaluate(path, stash);
    }
}

