/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.section.ApiCallSection;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class DoSection
implements ExecutableSection {
    private static final Logger logger = Loggers.getLogger(DoSection.class);
    private final XContentLocation location;
    private String catchParam;
    private ApiCallSection apiCallSection;
    private List<String> expectedWarningHeaders = Collections.emptyList();
    private static Map<String, Tuple<String, Matcher<Integer>>> catches = new HashMap<String, Tuple<String, Matcher<Integer>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        DoSection doSection = new DoSection(parser.getTokenLocation());
        ApiCallSection apiCallSection = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrayList<String> expectedWarnings = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (!"catch".equals(currentFieldName)) continue;
                doSection.setCatch(parser.text());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("warnings".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.VALUE_STRING) {
                        expectedWarnings.add(parser.text());
                    }
                    if (token == XContentParser.Token.END_ARRAY) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[warnings] must be a string array but saw [" + token + "]", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "unknown array [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("headers".equals(currentFieldName)) {
                String headerName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        headerName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    headers.put(headerName, parser.text());
                }
                continue;
            }
            if (currentFieldName == null) continue;
            apiCallSection = new ApiCallSection(currentFieldName);
            String paramName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    paramName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("body".equals(paramName)) {
                        String body = parser.text();
                        XContentType bodyContentType = XContentFactory.xContentType((CharSequence)body);
                        XContentParser bodyParser = XContentFactory.xContent((XContentType)bodyContentType).createParser(NamedXContentRegistry.EMPTY, body);
                        while (bodyParser.nextToken() != null) {
                            apiCallSection.addBody(bodyParser.mapOrdered());
                        }
                        continue;
                    }
                    apiCallSection.addParam(paramName, parser.text());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !"body".equals(paramName)) continue;
                apiCallSection.addBody(parser.mapOrdered());
            }
        }
        try {
            if (apiCallSection == null) {
                throw new IllegalArgumentException("client call section is mandatory within a do section");
            }
            if (!headers.isEmpty()) {
                apiCallSection.addHeaders(headers);
            }
            doSection.setApiCallSection(apiCallSection);
            doSection.setExpectedWarningHeaders(Collections.unmodifiableList(expectedWarnings));
        }
        finally {
            parser.nextToken();
        }
        return doSection;
    }

    public DoSection(XContentLocation location) {
        this.location = location;
    }

    public String getCatch() {
        return this.catchParam;
    }

    public void setCatch(String catchParam) {
        this.catchParam = catchParam;
    }

    public ApiCallSection getApiCallSection() {
        return this.apiCallSection;
    }

    public void setApiCallSection(ApiCallSection apiCallSection) {
        this.apiCallSection = apiCallSection;
    }

    public List<String> getExpectedWarningHeaders() {
        return this.expectedWarningHeaders;
    }

    public void setExpectedWarningHeaders(List<String> expectedWarningHeaders) {
        this.expectedWarningHeaders = expectedWarningHeaders;
    }

    @Override
    public XContentLocation getLocation() {
        return this.location;
    }

    @Override
    public void execute(ClientYamlTestExecutionContext executionContext) throws IOException {
        if ("param".equals(this.catchParam)) {
            logger.info("found [catch: param], no request sent");
            return;
        }
        try {
            ClientYamlTestResponse response = executionContext.callApi(this.apiCallSection.getApi(), this.apiCallSection.getParams(), this.apiCallSection.getBodies(), this.apiCallSection.getHeaders());
            if (Strings.hasLength((String)this.catchParam)) {
                String catchStatusCode;
                if (catches.containsKey(this.catchParam)) {
                    catchStatusCode = (String)catches.get(this.catchParam).v1();
                } else if (this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                    catchStatusCode = "4xx|5xx";
                } else {
                    throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
                }
                Assert.fail((String)this.formatStatusCodeMessage(response, catchStatusCode));
            }
            this.assertWarnings(response.getWarningHeaders());
        }
        catch (ClientYamlTestResponseException e) {
            ClientYamlTestResponse restTestResponse = e.getRestTestResponse();
            if (!Strings.hasLength((String)this.catchParam)) {
                Assert.fail((String)this.formatStatusCodeMessage(restTestResponse, "2xx"));
            }
            if (catches.containsKey(this.catchParam)) {
                this.assertStatusCode(restTestResponse);
            }
            if (this.catchParam.length() > 2 && this.catchParam.startsWith("/") && this.catchParam.endsWith("/")) {
                Assert.assertThat((String)this.formatStatusCodeMessage(restTestResponse, "4xx|5xx"), (Object)e.getResponseException().getResponse().getStatusLine().getStatusCode(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)));
                Object error = executionContext.response("error");
                Assert.assertThat((String)"error was expected in the response", (Object)error, (Matcher)Matchers.notNullValue());
                String regex = this.catchParam.substring(1, this.catchParam.length() - 1);
                Assert.assertThat((String)"the error message was expected to match the provided regex but didn't", (Object)error.toString(), (Matcher)RegexMatcher.matches(regex));
            }
            throw new UnsupportedOperationException("catch value [" + this.catchParam + "] not supported");
        }
    }

    void assertWarnings(List<String> warningHeaders) {
        StringBuilder failureMessage = null;
        LinkedHashSet<String> expected = new LinkedHashSet<String>(this.expectedWarningHeaders);
        for (String header : warningHeaders) {
            if (expected.remove(header)) continue;
            if (failureMessage == null) {
                failureMessage = new StringBuilder("got unexpected warning headers [");
            }
            failureMessage.append('\n').append(header);
        }
        if (!expected.isEmpty()) {
            if (failureMessage == null) {
                failureMessage = new StringBuilder();
            } else {
                failureMessage.append("\n] ");
            }
            failureMessage.append("didn't get expected warning headers [");
            for (String header : expected) {
                failureMessage.append('\n').append(header);
            }
        }
        if (failureMessage != null) {
            Assert.fail((String)(failureMessage + "\n]"));
        }
    }

    private void assertStatusCode(ClientYamlTestResponse restTestResponse) {
        Tuple<String, Matcher<Integer>> stringMatcherTuple = catches.get(this.catchParam);
        Assert.assertThat((String)this.formatStatusCodeMessage(restTestResponse, (String)stringMatcherTuple.v1()), (Object)restTestResponse.getStatusCode(), (Matcher)((Matcher)stringMatcherTuple.v2()));
    }

    private String formatStatusCodeMessage(ClientYamlTestResponse restTestResponse, String expected) {
        String api = this.apiCallSection.getApi();
        if ("raw".equals(api)) {
            api = api + "[method=" + this.apiCallSection.getParams().get("method") + " path=" + this.apiCallSection.getParams().get("path") + "]";
        }
        return "expected [" + expected + "] status code but api [" + api + "] returned [" + restTestResponse.getStatusCode() + " " + restTestResponse.getReasonPhrase() + "] [" + restTestResponse.getBodyAsString() + "]";
    }

    static {
        catches.put("unauthorized", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"401", (Object)Matchers.equalTo((Object)401)));
        catches.put("forbidden", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"403", (Object)Matchers.equalTo((Object)403)));
        catches.put("missing", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"404", (Object)Matchers.equalTo((Object)404)));
        catches.put("request_timeout", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"408", (Object)Matchers.equalTo((Object)408)));
        catches.put("conflict", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"409", (Object)Matchers.equalTo((Object)409)));
        catches.put("unavailable", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"503", (Object)Matchers.equalTo((Object)503)));
        catches.put("request", (Tuple<String, Matcher<Integer>>)Tuple.tuple((Object)"4xx|5xx", (Object)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)401)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)403)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)404)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)408)), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)409)))));
    }
}

