/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.SkipSection;

public class SetupSection {
    public static final SetupSection EMPTY = new SetupSection();
    private SkipSection skipSection;
    private List<DoSection> doSections = new ArrayList<DoSection>();

    public static SetupSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("setup".equals(parser.currentName())) {
            parser.nextToken();
            SetupSection section = SetupSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static SetupSection parse(XContentParser parser) throws IOException {
        SetupSection setupSection = new SetupSection();
        setupSection.setSkipSection(SkipSection.parseIfNext(parser));
        while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
            ParserUtils.advanceToFieldName(parser);
            if (!"do".equals(parser.currentName())) {
                throw new IllegalArgumentException("section [" + parser.currentName() + "] not supported within setup section");
            }
            parser.nextToken();
            setupSection.addDoSection(DoSection.parse(parser));
            parser.nextToken();
        }
        parser.nextToken();
        return setupSection;
    }

    public SkipSection getSkipSection() {
        return this.skipSection;
    }

    public void setSkipSection(SkipSection skipSection) {
        this.skipSection = skipSection;
    }

    public List<DoSection> getDoSections() {
        return this.doSections;
    }

    public void addDoSection(DoSection doSection) {
        this.doSections.add(doSection);
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    static {
        EMPTY.setSkipSection(SkipSection.EMPTY);
    }
}

