/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.couchdb;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jackson.JsonNode;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.StreamingViewResult;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbInstance;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.couchdb.CouchDbDataSet;
import org.eobjects.metamodel.couchdb.CouchDbTableCreationBuilder;
import org.eobjects.metamodel.couchdb.CouchDbUpdateCallback;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.SimpleTableDef;

public class CouchDbDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    public static final int DEFAULT_PORT = 5984;
    public static final String FIELD_ID = "_id";
    public static final String FIELD_REV = "_rev";
    private static final String SCHEMA_NAME = "CouchDB";
    private final CouchDbInstance _couchDbInstance;
    private final SimpleTableDef[] _tableDefs;

    public CouchDbDataContext(StdHttpClient.Builder httpClientBuilder, SimpleTableDef ... tableDefs) {
        this(httpClientBuilder.build(), tableDefs);
    }

    public CouchDbDataContext(StdHttpClient.Builder httpClientBuilder) {
        this(httpClientBuilder.build());
    }

    public CouchDbDataContext(HttpClient httpClient, SimpleTableDef ... tableDefs) {
        this((CouchDbInstance)new StdCouchDbInstance(httpClient), tableDefs);
    }

    public CouchDbDataContext(HttpClient httpClient) {
        this((CouchDbInstance)new StdCouchDbInstance(httpClient));
    }

    public CouchDbDataContext(CouchDbInstance couchDbInstance) {
        this(couchDbInstance, CouchDbDataContext.detectSchema(couchDbInstance));
    }

    public CouchDbDataContext(CouchDbInstance couchDbInstance, SimpleTableDef ... tableDefs) {
        this._couchDbInstance = couchDbInstance;
        this._tableDefs = tableDefs;
    }

    public static SimpleTableDef[] detectSchema(CouchDbInstance couchDbInstance) {
        ArrayList<SimpleTableDef> tableDefs = new ArrayList<SimpleTableDef>();
        List databaseNames = couchDbInstance.getAllDatabases();
        for (String databaseName : databaseNames) {
            if (databaseName.startsWith("_")) continue;
            CouchDbConnector connector = couchDbInstance.createConnector(databaseName, false);
            SimpleTableDef tableDef = CouchDbDataContext.detectTable(connector);
            tableDefs.add(tableDef);
        }
        return tableDefs.toArray(new SimpleTableDef[tableDefs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleTableDef detectTable(CouchDbConnector connector) {
        TreeMap<String, EnumSet<ColumnType>> columnsAndTypes = new TreeMap<String, EnumSet<ColumnType>>();
        StreamingViewResult streamingView = connector.queryForStreamingView(new ViewQuery().allDocs().includeDocs(true).limit(1000));
        try {
            for (ViewResult.Row row : streamingView) {
                JsonNode doc = row.getDocAsNode();
                Iterator fieldIterator = doc.getFields();
                while (fieldIterator.hasNext()) {
                    JsonNode value;
                    Map.Entry entry = (Map.Entry)fieldIterator.next();
                    String key = (String)entry.getKey();
                    EnumSet<ColumnType> types = (EnumSet<ColumnType>)columnsAndTypes.get(key);
                    if (types == null) {
                        types = EnumSet.noneOf(ColumnType.class);
                        columnsAndTypes.put(key, types);
                    }
                    if ((value = (JsonNode)entry.getValue()) == null || value.isNull()) continue;
                    if (value.isTextual()) {
                        types.add(ColumnType.VARCHAR);
                        continue;
                    }
                    if (value.isArray()) {
                        types.add(ColumnType.LIST);
                        continue;
                    }
                    if (value.isObject()) {
                        types.add(ColumnType.MAP);
                        continue;
                    }
                    if (value.isBoolean()) {
                        types.add(ColumnType.BOOLEAN);
                        continue;
                    }
                    if (value.isInt()) {
                        types.add(ColumnType.INTEGER);
                        continue;
                    }
                    if (value.isLong()) {
                        types.add(ColumnType.BIGINT);
                        continue;
                    }
                    if (!value.isDouble()) continue;
                    types.add(ColumnType.DOUBLE);
                }
            }
        }
        finally {
            streamingView.close();
        }
        String[] columnNames = new String[columnsAndTypes.size()];
        ColumnType[] columnTypes = new ColumnType[columnsAndTypes.size()];
        int i = 0;
        for (Map.Entry columnAndTypes : columnsAndTypes.entrySet()) {
            String columnName = (String)columnAndTypes.getKey();
            Set columnTypeSet = (Set)columnAndTypes.getValue();
            ColumnType columnType = columnTypeSet.isEmpty() ? ColumnType.OTHER : (columnTypeSet.size() == 1 ? (ColumnType)columnTypeSet.iterator().next() : ColumnType.OTHER);
            columnNames[i] = columnName;
            columnTypes[i] = columnType;
            ++i;
        }
        SimpleTableDef tableDef = new SimpleTableDef(connector.getDatabaseName(), columnNames, columnTypes);
        return tableDef;
    }

    public CouchDbInstance getCouchDbInstance() {
        return this._couchDbInstance;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(SCHEMA_NAME);
        for (SimpleTableDef tableDef : this._tableDefs) {
            MutableTable table = tableDef.toTable().setSchema((Schema)schema);
            CouchDbTableCreationBuilder.addMandatoryColumns(table);
            schema.addTable(table);
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return SCHEMA_NAME;
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int firstRow, int maxRows) {
        String databaseName = table.getName();
        CouchDbConnector connector = this._couchDbInstance.createConnector(databaseName, false);
        ViewQuery query = new ViewQuery().allDocs().includeDocs(true);
        if (maxRows > 0) {
            query = query.limit(maxRows);
        }
        if (firstRow > 1) {
            int skip = firstRow - 1;
            query = query.skip(skip);
        }
        StreamingViewResult streamingView = connector.queryForStreamingView(query);
        SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])columns);
        return new CouchDbDataSet(selectItems, streamingView);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        return this.materializeMainSchemaTable(table, columns, 1, maxRows);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems.isEmpty()) {
            String databaseName = table.getName();
            CouchDbConnector connector = this._couchDbInstance.createConnector(databaseName, false);
            long docCount = connector.getDbInfo().getDocCount();
            return docCount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript script) {
        CouchDbUpdateCallback callback = new CouchDbUpdateCallback(this);
        try {
            script.run((UpdateCallback)callback);
        }
        finally {
            callback.close();
        }
    }
}

