/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.couchdb;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DocumentOperationResult;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.couchdb.CouchDbDataContext;
import org.eobjects.metamodel.couchdb.CouchDbInsertionBuilder;
import org.eobjects.metamodel.couchdb.CouchDbRowDeletionBuilder;
import org.eobjects.metamodel.couchdb.CouchDbRowUpdationBuilder;
import org.eobjects.metamodel.couchdb.CouchDbTableCreationBuilder;
import org.eobjects.metamodel.couchdb.CouchDbTableDropBuilder;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CouchDbUpdateCallback
extends AbstractUpdateCallback
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CouchDbUpdateCallback.class);
    private final Map<String, CouchDbConnector> _connectors = new HashMap<String, CouchDbConnector>();

    public CouchDbUpdateCallback(CouchDbDataContext couchDbDataContext) {
        super((DataContext)couchDbDataContext);
    }

    public CouchDbDataContext getDataContext() {
        return (CouchDbDataContext)super.getDataContext();
    }

    public boolean isUpdateSupported() {
        return true;
    }

    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new CouchDbRowUpdationBuilder(this, table);
    }

    public boolean isCreateTableSupported() {
        return true;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new CouchDbTableCreationBuilder(this, schema, name);
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new CouchDbTableDropBuilder(this, table);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new CouchDbInsertionBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new CouchDbRowDeletionBuilder(this, table);
    }

    @Override
    public void close() {
        Collection<CouchDbConnector> connectorSet = this._connectors.values();
        for (CouchDbConnector connector : connectorSet) {
            ArrayList<String> errornousResultsDescriptions = new ArrayList<String>();
            List results = connector.flushBulkBuffer();
            for (DocumentOperationResult result : results) {
                if (!result.isErroneous()) continue;
                String id = result.getId();
                String error = result.getError();
                String reason = result.getReason();
                String revision = result.getRevision();
                logger.error("Error occurred while flushing bulk buffer: {}, id: {}, revision: {}, reason: {}", new Object[]{error, id, revision, reason});
                errornousResultsDescriptions.add(error);
            }
            if (errornousResultsDescriptions.isEmpty()) continue;
            throw new MetaModelException(errornousResultsDescriptions.size() + " out of " + results.size() + " operations in bulk was errornous: " + errornousResultsDescriptions);
        }
    }

    public CouchDbConnector getConnector(String name) {
        CouchDbConnector connector = this._connectors.get(name);
        if (connector == null) {
            CouchDbInstance instance = this.getDataContext().getCouchDbInstance();
            connector = instance.createConnector(name, false);
            this._connectors.put(name, connector);
        }
        return connector;
    }
}

