/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.GroupServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Group"}, description="The API for group related operations")
@RestController
@RequestMapping(value={"/api/ff4j/store/groups/{groupName}"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/GroupResource;", "", "groupServices", "Lorg/ff4j/services/GroupServices;", "(Lorg/ff4j/services/GroupServices;)V", "getGroupServices", "()Lorg/ff4j/services/GroupServices;", "disableGroup", "", "groupName", "", "enableGroup", "getFeaturesByGroup", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "ff4j-spring-boot-web-api"})
public class GroupResource {
    @NotNull
    private final GroupServices groupServices;

    @ApiOperation(value="Get all the features belonging to the group", response=FeatureApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="features belonging to the group"), @ApiResponse(code=404, message="Group not found")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public Collection<FeatureApiBean> getFeaturesByGroup(@PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        return this.getGroupServices().getFeaturesByGroup(groupName);
    }

    @ApiOperation(value="Enable a group", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Group has been enabled"), @ApiResponse(code=404, message="Group not found")})
    @PostMapping(produces={"application/json"}, value={"/enable"})
    public void enableGroup(@PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        this.getGroupServices().enableGroup(groupName);
    }

    @ApiOperation(value="Disable a group", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Group has been disabled"), @ApiResponse(code=404, message="Group not found")})
    @PostMapping(produces={"application/json"}, value={"/disable"})
    public void disableGroup(@PathVariable(value="groupName") @NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        this.getGroupServices().disableGroup(groupName);
    }

    @NotNull
    public GroupServices getGroupServices() {
        return this.groupServices;
    }

    public GroupResource(@Autowired @NotNull GroupServices groupServices) {
        Intrinsics.checkParameterIsNotNull((Object)groupServices, (String)"groupServices");
        this.groupServices = groupServices;
    }
}

