/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.PropertyServices;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.spring.boot.web.api.utils.FeatureWebUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Property"}, description="The API for property related operations")
@RestController
@RequestMapping(value={"/api/ff4j/propertyStore/properties/{name}"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000e\u001a\u00020\f2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0010\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/PropertyResource;", "", "propertyServices", "Lorg/ff4j/services/PropertyServices;", "(Lorg/ff4j/services/PropertyServices;)V", "getPropertyServices", "()Lorg/ff4j/services/PropertyServices;", "createOrUpdateProperty", "Lorg/springframework/http/ResponseEntity;", "propertyName", "", "propertyApiBean", "Lorg/ff4j/services/domain/PropertyApiBean;", "deleteProperty", "getProperty", "updatePropertyName", "newPropertyName", "ff4j-spring-boot-web-api"})
public class PropertyResource {
    @NotNull
    private final PropertyServices propertyServices;

    @ApiOperation(value="Read information about a property", response=PropertyApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Information about property"), @ApiResponse(code=404, message="Property not found")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public PropertyApiBean getProperty(@PathVariable(value="name") @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return this.getPropertyServices().getProperty(propertyName);
    }

    @ApiOperation(value="Create or update a property", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Property name is blank (or) property name did not match with the requested property name to be created or updated"), @ApiResponse(code=201, message="Property has been created"), @ApiResponse(code=202, message="Property has been updated"), @ApiResponse(code=204, message="No content, no changes made to the feature")})
    @PutMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<?> createOrUpdateProperty(@PathVariable(value="name") @NotNull String propertyName, @RequestBody @NotNull PropertyApiBean propertyApiBean) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        Intrinsics.checkParameterIsNotNull((Object)propertyApiBean, (String)"propertyApiBean");
        return FeatureWebUtils.INSTANCE.getBooleanResponseEntityByHttpStatus(this.getPropertyServices().createOrUpdateProperty(propertyName, propertyApiBean));
    }

    @ApiOperation(value="Delete a property", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="No content, property is deleted"), @ApiResponse(code=404, message="Property not found")})
    @DeleteMapping(produces={"application/json"})
    @NotNull
    public ResponseEntity<Object> deleteProperty(@PathVariable(value="name") @NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        this.getPropertyServices().deleteProperty(propertyName);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Update value of a property", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Property has been updated"), @ApiResponse(code=404, message="Property not found"), @ApiResponse(code=400, message="Invalid new value")})
    @PostMapping(produces={"application/json"}, value={"/update/{value}"})
    @NotNull
    public ResponseEntity<Object> updatePropertyName(@PathVariable(value="name") @NotNull String propertyName, @PathVariable(value="value") @NotNull String newPropertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        Intrinsics.checkParameterIsNotNull((Object)newPropertyName, (String)"newPropertyName");
        this.getPropertyServices().updatePropertyName(propertyName, newPropertyName);
        return new ResponseEntity(HttpStatus.ACCEPTED);
    }

    @NotNull
    public PropertyServices getPropertyServices() {
        return this.propertyServices;
    }

    public PropertyResource(@Autowired @NotNull PropertyServices propertyServices) {
        Intrinsics.checkParameterIsNotNull((Object)propertyServices, (String)"propertyServices");
        this.propertyServices = propertyServices;
    }
}

