/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.PropertyStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.domain.PropertyStoreApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PropertyStore"}, description="The API for accessing the store for all properties")
@RestController
@RequestMapping(value={"/api/ff4j/propertyStore"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0017J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0017J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/PropertyStoreResource;", "", "propertyStoreServices", "Lorg/ff4j/services/PropertyStoreServices;", "(Lorg/ff4j/services/PropertyStoreServices;)V", "getPropertyStoreServices", "()Lorg/ff4j/services/PropertyStoreServices;", "clearCachedPropertyStore", "Lorg/springframework/http/ResponseEntity;", "deleteAllProperties", "getAllProperties", "", "Lorg/ff4j/services/domain/PropertyApiBean;", "getPropertiesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "getPropertyStore", "Lorg/ff4j/services/domain/PropertyStoreApiBean;", "ff4j-spring-boot-web-api"})
public class PropertyStoreResource {
    @NotNull
    private final PropertyStoreServices propertyStoreServices;

    @ApiOperation(value="Display information regarding Properties Store", response=PropertyStoreApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="status of current properties store")})
    @GetMapping(produces={"application/json"})
    @NotNull
    public PropertyStoreApiBean getPropertyStore() {
        return this.getPropertyStoreServices().getPropertyStore();
    }

    @ApiOperation(value="Display all the Properties", response=PropertyApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="get all Properties")})
    @GetMapping(produces={"application/json"}, value={"//properties"})
    @NotNull
    public List<PropertyApiBean> getAllProperties() {
        return this.getPropertyStoreServices().getAllProperties();
    }

    @ApiOperation(value="Display information related to Cache")
    @ApiResponses(value={@ApiResponse(code=200, response=CacheApiBean.class, message="Gets the cached properties"), @ApiResponse(code=404, message="property store is not cached")})
    @GetMapping(produces={"application/json"}, value={"/cache"})
    @NotNull
    public CacheApiBean getPropertiesFromCache() {
        return this.getPropertyStoreServices().getPropertiesFromCache();
    }

    @ApiOperation(value="Delete all Properties in store")
    @ApiResponses(value={@ApiResponse(code=204, response=ResponseEntity.class, message="all properties have been deleted")})
    @DeleteMapping(value={"/clear"})
    @NotNull
    public ResponseEntity<Object> deleteAllProperties() {
        this.getPropertyStoreServices().deleteAllProperties();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Clear cache", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="cache is cleared"), @ApiResponse(code=404, message="property store is not cached")})
    @DeleteMapping(value={"/clearCache"})
    @NotNull
    public ResponseEntity<Object> clearCachedPropertyStore() {
        this.getPropertyStoreServices().clearCachedPropertyStore();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @NotNull
    public PropertyStoreServices getPropertyStoreServices() {
        return this.propertyStoreServices;
    }

    public PropertyStoreResource(@Autowired @NotNull PropertyStoreServices propertyStoreServices) {
        Intrinsics.checkParameterIsNotNull((Object)propertyStoreServices, (String)"propertyStoreServices");
        this.propertyStoreServices = propertyStoreServices;
    }
}

