/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.bean;

import java.io.Serializable;
import org.ff4j.FF4j;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.FeatureStore;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.security.AuthorizationsManager;

public class HomeBean
implements Serializable {
    private static final long serialVersionUID = 9115704270593636619L;
    private String uptime;
    private String featureStore = "disabled";
    private String propertyStore = "disabled";
    private String security = "disabled";
    private String monitoring = "disabled";
    private String caching = "disabled";
    private String version = "disabled";
    private int nbFeature = 0;
    private int nbProperties = 0;
    private int nbGroup = 0;
    private int nbEvents = 0;

    public HomeBean() {
    }

    public HomeBean(FF4j ff4j) {
        FF4jCacheProxy cacheProxy;
        AuthorizationsManager authManager;
        EventRepository evtRepository;
        this.version = ff4j.getVersion();
        this.setUptime(ff4j.getStartTime());
        if (ff4j.getFeatureStore() != null) {
            FeatureStore fs = ff4j.getConcreteFeatureStore();
            this.featureStore = fs.getClass().getSimpleName();
            this.nbFeature = fs.readAll().size();
            this.nbGroup = fs.readAllGroups().size();
            this.featureStore = this.featureStore.replaceAll("FeatureStore", "").toLowerCase();
        }
        if (ff4j.getPropertiesStore() != null) {
            PropertyStore ps = ff4j.getConcretePropertyStore();
            this.propertyStore = ps.getClass().getSimpleName();
            this.nbProperties = ps.listPropertyNames().size();
            this.propertyStore = this.propertyStore.replaceAll("PropertyStore", "").toLowerCase();
        }
        if ((evtRepository = ff4j.getEventRepository()) != null) {
            this.monitoring = evtRepository.getClass().getSimpleName();
            this.monitoring = this.monitoring.replaceAll("EventRepository", "").toLowerCase();
        }
        if ((authManager = ff4j.getAuthorizationsManager()) != null) {
            this.security = authManager.getClass().getSimpleName();
            this.security = this.security.replaceAll("AuthorisationManager", "");
            this.security = this.security.replaceAll("AuthorizationManager", "");
            this.security = this.security.toLowerCase();
        }
        if ((cacheProxy = ff4j.getCacheProxy()) != null) {
            this.caching = cacheProxy.getCacheManager().getCacheProviderName().toLowerCase();
        }
    }

    public String getSecurity() {
        return this.security;
    }

    public String getMonitoring() {
        return this.monitoring;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(long ff4jStartTime) {
        StringBuilder sb = new StringBuilder();
        long uptime = System.currentTimeMillis() - ff4jStartTime;
        long daynumber = uptime / 86400000L;
        long hourNumber = (uptime -= daynumber * 1000L * 3600L * 24L) / 3600000L;
        long minutenumber = (uptime -= hourNumber * 1000L * 3600L) / 60000L;
        long secondnumber = (uptime -= minutenumber * 1000L * 60L) / 1000L;
        sb.append(daynumber + " days ");
        sb.append(hourNumber + " hours ");
        sb.append(minutenumber + " min ");
        sb.append(secondnumber + " sec");
        this.uptime = sb.toString();
    }

    public int getNbFeature() {
        return this.nbFeature;
    }

    public int getNbGroup() {
        return this.nbGroup;
    }

    public int getNbEvents() {
        return this.nbEvents;
    }

    public String getFeatureStore() {
        return this.featureStore;
    }

    public String getPropertyStore() {
        return this.propertyStore;
    }

    public int getNbProperties() {
        return this.nbProperties;
    }

    public String getCaching() {
        return this.caching;
    }
}

