/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.interceptor;

import org.flowable.engine.common.impl.cfg.BaseTransactionContext;
import org.flowable.engine.common.impl.cfg.TransactionContextFactory;
import org.flowable.engine.common.impl.interceptor.AbstractCommandContext;
import org.flowable.engine.common.impl.interceptor.BaseCommandContextCloseListener;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.TransactionCommandContextCloseListener;
import org.flowable.engine.common.impl.transaction.TransactionContextHolder;
import org.flowable.idm.engine.impl.cfg.TransactionContext;
import org.flowable.idm.engine.impl.cfg.TransactionListener;
import org.flowable.idm.engine.impl.context.Context;
import org.flowable.idm.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.idm.engine.impl.interceptor.Command;
import org.flowable.idm.engine.impl.interceptor.CommandContext;

public class TransactionContextInterceptor
extends AbstractCommandInterceptor {
    protected TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory;

    public TransactionContextInterceptor() {
    }

    public TransactionContextInterceptor(TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext commandContext = Context.getCommandContext();
        boolean isReused = commandContext.isReused();
        boolean isCurrentTransactionContextActive = TransactionContextHolder.getTransactionContext() != null;
        try {
            if (this.isNewTransactionContextNeeded(isReused, isCurrentTransactionContextActive)) {
                TransactionContext transactionContext = (TransactionContext)this.transactionContextFactory.openTransactionContext((AbstractCommandContext)commandContext);
                Context.setTransactionContext(transactionContext);
                commandContext.addCloseListener((BaseCommandContextCloseListener)new TransactionCommandContextCloseListener((BaseTransactionContext)transactionContext));
            }
            T t = this.next.execute(config, command);
            return t;
        }
        finally {
            if (this.isNewTransactionContextNeeded(isReused, isCurrentTransactionContextActive)) {
                Context.removeTransactionContext();
            }
        }
    }

    protected boolean isNewTransactionContextNeeded(boolean isReused, boolean isCurrentTransactionContextActive) {
        return !isCurrentTransactionContextActive && this.transactionContextFactory != null && !isReused;
    }

    public TransactionContextFactory<TransactionListener, CommandContext> getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public void setTransactionContextFactory(TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }
}

