/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveJobToDeadLetterJobCmd
implements Command<DeadLetterJobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveJobToDeadLetterJobCmd.class);
    protected String jobId;
    protected JobServiceConfiguration jobServiceConfiguration;

    public MoveJobToDeadLetterJobCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public DeadLetterJobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        AbstractRuntimeJobEntity job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().findById(this.jobId);
        if (job == null) {
            job = (AbstractRuntimeJobEntity)this.jobServiceConfiguration.getJobEntityManager().findById(this.jobId);
        }
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving job to deadletter job table {}", (Object)job.getId());
        }
        DeadLetterJobEntity deadLetterJob = this.jobServiceConfiguration.getJobManager().moveJobToDeadLetterJob(job);
        return deadLetterJob;
    }

    public String getJobId() {
        return this.jobId;
    }
}

