/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class RestUrlBuilder {
    protected String baseUrl = "";

    protected RestUrlBuilder() {
    }

    protected RestUrlBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String buildUrl(String[] fragments, Object ... arguments) {
        return this.baseUrl + "/" + MessageFormat.format(StringUtils.join((Object[])fragments, (char)'/'), arguments);
    }

    public static RestUrlBuilder usingBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new FlowableIllegalArgumentException("baseUrl can not be null");
        }
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return new RestUrlBuilder(baseUrl);
    }

    public static RestUrlBuilder fromRequest(HttpServletRequest request) {
        return RestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request).build().toUriString());
    }

    public static RestUrlBuilder fromCurrentRequest() {
        return RestUrlBuilder.usingBaseUrl(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString());
    }
}

