/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.HistoryService;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.history.HistoricProcessInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History"}, description="Manage History", authorizations={@Authorization(value="basicAuth")})
public class HistoricProcessInstanceResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @ApiOperation(value="Get a historic process instance", tags={"History"}, nickname="getHistoricProcessInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that the historic process instances could be found."), @ApiResponse(code=404, message="Indicates that the historic process instances could not be found.")})
    @RequestMapping(value={"/history/historic-process-instances/{processInstanceId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public HistoricProcessInstanceResponse getProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletRequest request) {
        return this.restResponseFactory.createHistoricProcessInstanceResponse(this.getHistoricProcessInstanceFromRequest(processInstanceId));
    }

    @ApiOperation(value=" Delete a historic process instance", tags={"History"}, nickname="deleteHitoricProcessInstance")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates that the historic process instance was deleted."), @ApiResponse(code=404, message="Indicates that the historic process instance could not be found.")})
    @RequestMapping(value={"/history/historic-process-instances/{processInstanceId}"}, method={RequestMethod.DELETE})
    public void deleteProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletResponse response) {
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected HistoricProcessInstance getHistoricProcessInstanceFromRequest(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", HistoricProcessInstance.class);
        }
        return processInstance;
    }
}

