/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.history;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.HistoryService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History"}, description="Manage History", authorizations={@Authorization(value="basicAuth")})
public class HistoricProcessInstanceVariableDataResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected HistoryService historyService;

    @RequestMapping(value={"/history/historic-process-instances/{processInstanceId}/variables/{variableName}/data"}, method={RequestMethod.GET})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the requested variable data is returned."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the process instance doesn\u2019t have a variable with the given name or the variable doesn\u2019t have a binary stream available. Status message provides additional information.")})
    @ApiOperation(value="Get the binary data for a historic process instance variable", tags={"History"}, nickname="getHistoricProcessInstanceVariableData", notes="The response body contains the binary value of the variable. When the variable is of type binary, the content-type of the response is set to application/octet-stream, regardless of the content of the variable or the request accept-type header. In case of serializable, application/x-java-serialized-object is used as content-type.")
    @ResponseBody
    public byte[] getVariableData(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = null;
            RestVariable variable = this.getVariableFromRequest(true, processInstanceId, variableName, request);
            if ("binary".equals(variable.getType())) {
                result = (byte[])variable.getValue();
                response.setContentType("application/octet-stream");
            } else if ("serializable".equals(variable.getType())) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                outputStream.writeObject(variable.getValue());
                outputStream.close();
                result = buffer.toByteArray();
                response.setContentType("application/x-java-serialized-object");
            } else {
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new FlowableException("Unexpected exception getting variable data", (Throwable)ioe);
        }
    }

    public RestVariable getVariableFromRequest(boolean includeBinary, String processInstanceId, String variableName, HttpServletRequest request) {
        HistoricProcessInstance processObject = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).includeProcessVariables().singleResult();
        if (processObject == null) {
            throw new FlowableObjectNotFoundException("Historic process instance '" + processInstanceId + "' couldn't be found.", HistoricProcessInstanceEntity.class);
        }
        Object value = processObject.getProcessVariables().get(variableName);
        if (value == null) {
            throw new FlowableObjectNotFoundException("Historic process instance '" + processInstanceId + "' variable value for " + variableName + " couldn't be found.", VariableInstanceEntity.class);
        }
        return this.restResponseFactory.createRestVariable(variableName, value, null, processInstanceId, 5, includeBinary);
    }
}

