/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.Group;
import org.flowable.rest.service.api.identity.BaseGroupResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Groups"}, description="Manage Groups", authorizations={@Authorization(value="basicAuth")})
public class GroupMembershipResource
extends BaseGroupResource {
    @ApiOperation(value="Delete a member from a group", tags={"Groups"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the group was found and the member has been deleted. The response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested group was not found or that the user is not a member of the group. The status description contains additional information about the error.")})
    @RequestMapping(value={"/identity/groups/{groupId}/members/{userId}"}, method={RequestMethod.DELETE})
    public void deleteMembership(@ApiParam(name="groupId") @PathVariable(value="groupId") String groupId, @ApiParam(name="userId") @PathVariable(value="userId") String userId, HttpServletRequest request, HttpServletResponse response) {
        Group group = this.getGroupFromRequest(groupId);
        if (this.identityService.createUserQuery().memberOfGroup(group.getId()).userId(userId).count() != 1L) {
            throw new FlowableObjectNotFoundException("User '" + userId + "' is not part of group '" + group.getId() + "'.", null);
        }
        this.identityService.deleteMembership(userId, group.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

