/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.engine.ManagementService;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.management.TableResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Database tables"}, description="Manage Database tables", authorizations={@Authorization(value="basicAuth")})
public class TableCollectionResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected ManagementService managementService;

    @ApiOperation(value=" List of tables", tags={"Database tables"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the request was successful.")})
    @RequestMapping(value={"/management/tables"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<TableResponse> getTables(HttpServletRequest request) {
        return this.restResponseFactory.createTableResponseList(this.managementService.getTableCount());
    }
}

