/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.dmn.api.DmnDecisionTable;
import org.flowable.rest.service.api.repository.BaseProcessDefinitionResource;
import org.flowable.rest.service.api.repository.DecisionTableResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionDecisionTableCollectionResource
extends BaseProcessDefinitionResource {
    @ApiOperation(value="Get all decision tables for a process-definition", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process definition was found and the decision tables are returned.", response=DmnDecisionTable.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/decision-tables"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<DecisionTableResponse> getDecisionTablesForProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        List decisionTables = this.repositoryService.getDecisionTablesForProcessDefinition(processDefinitionId);
        return this.restResponseFactory.createDecisionTableResponseList(decisionTables, processDefinitionId);
    }
}

