/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.form.api.FormDefinition;
import org.flowable.rest.service.api.repository.BaseProcessDefinitionResource;
import org.flowable.rest.service.api.repository.FormDefinitionResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionFormDefinitionCollectionResource
extends BaseProcessDefinitionResource {
    @ApiOperation(value="Get all form definitions for a process-definition", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process definition was found and the form definitions are returned.", response=FormDefinition.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/form-definitions"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<FormDefinitionResponse> getFormDefinitionsForProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        List formDefinitions = this.repositoryService.getFormDefinitionsForProcessDefinition(processDefinitionId);
        return this.restResponseFactory.createFormDefinitionResponseList(formDefinitions, processDefinitionId);
    }
}

