/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.query.QueryProperty;
import org.flowable.engine.impl.ProcessInstanceQueryProperty;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.rest.api.DataResponse;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.engine.variable.QueryVariable;
import org.flowable.rest.service.api.runtime.process.ProcessInstancePaginateList;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceQueryRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseProcessInstanceResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected RuntimeService runtimeService;

    protected DataResponse getQueryResponse(ProcessInstanceQueryRequest queryRequest, Map<String, String> requestParams) {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessDefinitionKey() != null) {
            query.processDefinitionKey(queryRequest.getProcessDefinitionKey());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getProcessBusinessKey() != null) {
            query.processInstanceBusinessKey(queryRequest.getProcessBusinessKey());
        }
        if (queryRequest.getInvolvedUser() != null) {
            query.involvedUser(queryRequest.getInvolvedUser());
        }
        if (queryRequest.getSuspended() != null) {
            if (queryRequest.getSuspended().booleanValue()) {
                query.suspended();
            } else {
                query.active();
            }
        }
        if (queryRequest.getSubProcessInstanceId() != null) {
            query.subProcessInstanceId(queryRequest.getSubProcessInstanceId());
        }
        if (queryRequest.getSuperProcessInstanceId() != null) {
            query.superProcessInstanceId(queryRequest.getSuperProcessInstanceId());
        }
        if (queryRequest.getExcludeSubprocesses() != null) {
            query.excludeSubprocesses(queryRequest.getExcludeSubprocesses().booleanValue());
        }
        if (queryRequest.getIncludeProcessVariables() != null && queryRequest.getIncludeProcessVariables().booleanValue()) {
            query.includeProcessVariables();
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        if (queryRequest.getTenantId() != null) {
            query.processInstanceTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.processInstanceTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.processInstanceWithoutTenantId();
        }
        return new ProcessInstancePaginateList(this.restResponseFactory).paginateList(requestParams, queryRequest, query, "id", allowedSortProperties);
    }

    protected void addVariables(ProcessInstanceQuery processInstanceQuery, List<QueryVariable> variables) {
        block11: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        processInstanceQuery.variableValueEquals(actualValue);
                        continue block11;
                    }
                    processInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    processInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block11;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case LIKE: {
                    if (actualValue instanceof String) {
                        processInstanceQuery.variableValueLike(variable.getName(), (String)actualValue);
                        continue block11;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported for like, but was: " + actualValue.getClass().getName());
                }
                case GREATER_THAN: {
                    processInstanceQuery.variableValueGreaterThan(variable.getName(), actualValue);
                    continue block11;
                }
                case GREATER_THAN_OR_EQUALS: {
                    processInstanceQuery.variableValueGreaterThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN: {
                    processInstanceQuery.variableValueLessThan(variable.getName(), actualValue);
                    continue block11;
                }
                case LESS_THAN_OR_EQUALS: {
                    processInstanceQuery.variableValueLessThanOrEqual(variable.getName(), actualValue);
                    continue block11;
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected ProcessInstance getProcessInstanceFromRequest(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.");
        }
        return processInstance;
    }

    static {
        allowedSortProperties.put("processDefinitionId", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processDefinitionKey", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_DEFINITION_KEY);
        allowedSortProperties.put("id", (QueryProperty)ProcessInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("tenantId", (QueryProperty)ProcessInstanceQueryProperty.TENANT_ID);
    }
}

