/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.IdentityLink;
import org.flowable.rest.service.api.engine.RestIdentityLink;
import org.flowable.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instances"}, description="Manage Process Instances", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceIdentityLinkResource
extends BaseProcessInstanceResource {
    @ApiOperation(value="Get a specific involved people from process instance", tags={"Process Instances"}, nickname="getProcessInstanceIdentityLinks")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the specified link is retrieved."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the link to delete doesn\u2019t exist. The response status contains additional information about the error.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks/users/{identityId}/{type}"}, method={RequestMethod.GET}, produces={"application/json"})
    public RestIdentityLink getIdentityLink(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, @ApiParam(name="type") @PathVariable(value="type") String type, HttpServletRequest request) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.validateIdentityLinkArguments(identityId, type);
        IdentityLink link = this.getIdentityLink(identityId, type, processInstance.getId());
        return this.restResponseFactory.createRestIdentityLink(link);
    }

    @ApiOperation(value="Remove an involved user to from process instance", tags={"Process Instances"}, nickname="deleteProcessInstanceIdentityLinks")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the process instance was found and the link has been deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested process instance was not found or the link to delete doesn\u2019t exist. The response status contains additional information about the error.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/identitylinks/users/{identityId}/{type}"}, method={RequestMethod.DELETE})
    public void deleteIdentityLink(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="identityId") @PathVariable(value="identityId") String identityId, @ApiParam(name="type") @PathVariable(value="type") String type, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.validateIdentityLinkArguments(identityId, type);
        this.getIdentityLink(identityId, type, processInstance.getId());
        this.runtimeService.deleteUserIdentityLink(processInstance.getId(), identityId, type);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void validateIdentityLinkArguments(String identityId, String type) {
        if (identityId == null) {
            throw new FlowableIllegalArgumentException("IdentityId is required.");
        }
        if (type == null) {
            throw new FlowableIllegalArgumentException("Type is required.");
        }
    }

    protected IdentityLink getIdentityLink(String identityId, String type, String processInstanceId) {
        List allLinks = this.runtimeService.getIdentityLinksForProcessInstance(processInstanceId);
        for (IdentityLink link : allLinks) {
            if (!identityId.equals(link.getUserId()) || !link.getType().equals(type)) continue;
            return link;
        }
        throw new FlowableObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

