/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.rest.exception.FlowableConflictException;
import org.flowable.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceActionRequest;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceChangeActivityStateRequest;
import org.flowable.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instances"}, description="Manage Process Instances", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceResource
extends BaseProcessInstanceResource {
    @ApiOperation(value="Get a process instance", tags={"Process Instances"}, nickname="getProcessInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and returned."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ProcessInstanceResponse getProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, HttpServletRequest request) {
        return this.restResponseFactory.createProcessInstanceResponse(this.getProcessInstanceFromRequest(processInstanceId));
    }

    @ApiOperation(value="Delete a process instance", tags={"Process Instances"}, nickname="deleteProcessInstance")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the process instance was found and deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}"}, method={RequestMethod.DELETE})
    public void deleteProcessInstance(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestParam(value="deleteReason", required=false) String deleteReason, HttpServletResponse response) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), deleteReason);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ApiOperation(value="Activate or suspend a process instance", tags={"Process Instances"}, notes="## Activate a process instance\n\n ```JSON\n{\n  \"action\" : \"suspend\"\n} ```\n\n\n## Suspend a process instance\n\n ```JSON\n{\n  \"action\" : \"activate\"\n} ```\n\n\n")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and action was executed."), @ApiResponse(code=400, message="\t\nIndicates an invalid action was supplied."), @ApiResponse(code=409, message="Indicates the requested process instance action cannot be executed since the process-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ProcessInstanceResponse performProcessInstanceAction(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestBody ProcessInstanceActionRequest actionRequest, HttpServletRequest request) {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest(processInstanceId);
        if ("activate".equals(actionRequest.getAction())) {
            return this.activateProcessInstance(processInstance);
        }
        if ("suspend".equals(actionRequest.getAction())) {
            return this.suspendProcessInstance(processInstance);
        }
        throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    @ApiOperation(value="Change the state a process instance", tags={"Process Instances"}, notes="```JSON\n{\n  \"cancelActivityId\" : \"task2\"\n  \"startActivityId\" : \"task1\"\n } ```\n\n\n")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and change state activity was executed."), @ApiResponse(code=409, message="Indicates the requested process instance action cannot be executed since the process-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested process instance was not found.")})
    @RequestMapping(value={"/runtime/process-instances/{processInstanceId}/change-state"}, method={RequestMethod.POST}, produces={"application/json"})
    public void changeActivityState(@ApiParam(name="processInstanceId") @PathVariable String processInstanceId, @RequestBody ProcessInstanceChangeActivityStateRequest activityStateRequest, HttpServletRequest request) {
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId).cancelActivityId(activityStateRequest.getCancelActivityId()).startActivityId(activityStateRequest.getStartActivityId()).changeState();
    }

    protected ProcessInstanceResponse activateProcessInstance(ProcessInstance processInstance) {
        if (!processInstance.isSuspended()) {
            throw new FlowableConflictException("Process instance with id '" + processInstance.getId() + "' is already active.");
        }
        this.runtimeService.activateProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = this.restResponseFactory.createProcessInstanceResponse(processInstance);
        response.setSuspended(false);
        return response;
    }

    protected ProcessInstanceResponse suspendProcessInstance(ProcessInstance processInstance) {
        if (processInstance.isSuspended()) {
            throw new FlowableConflictException("Process instance with id '" + processInstance.getId() + "' is already suspended.");
        }
        this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        ProcessInstanceResponse response = this.restResponseFactory.createProcessInstanceResponse(processInstance);
        response.setSuspended(true);
        return response;
    }
}

