/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskQuery;
import org.flowable.rest.service.api.engine.CommentRequest;
import org.flowable.rest.service.api.engine.CommentResponse;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskCommentCollectionResource
extends TaskBaseResource {
    @ApiOperation(value="Get all comments on a task", tags={"Tasks"}, nickname="listTaskComments")
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the task was found and the comments are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/comments"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<CommentResponse> getComments(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        return this.restResponseFactory.createRestCommentList(this.taskService.getTaskComments(task.getId()));
    }

    @ApiOperation(value="Create a new comment on a task", tags={"Tasks"}, nickname="createTaskComments")
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the comment was created and the result is returned."), @ApiResponse(code=400, message="Indicates the comment is missing from the request."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/comments"}, method={RequestMethod.POST}, produces={"application/json"})
    public CommentResponse createComment(@ApiParam(name="taskId") @PathVariable String taskId, @RequestBody CommentRequest comment, HttpServletRequest request, HttpServletResponse response) {
        Task task = this.getTaskFromRequest(taskId);
        if (comment.getMessage() == null) {
            throw new FlowableIllegalArgumentException("Comment text is required.");
        }
        String processInstanceId = null;
        if (comment.isSaveProcessInstanceId()) {
            Task taskEntity = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult();
            processInstanceId = taskEntity.getProcessInstanceId();
        }
        Comment createdComment = this.taskService.addComment(task.getId(), processInstanceId, comment.getMessage());
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createRestComment(createdComment);
    }
}

