/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.rest.service.api.engine.EventResponse;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskEventCollectionResource
extends TaskBaseResource {
    @ApiOperation(value="Get all events for a task", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task was found and the events are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @RequestMapping(value={"/runtime/tasks/{taskId}/events"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<EventResponse> getEvents(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        return this.restResponseFactory.createEventResponseList(this.taskService.getTaskEvents(task.getId()));
    }
}

