/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.idm.api.Group;
import org.flowable.rest.exception.FlowableConflictException;
import org.flowable.rest.service.api.identity.BaseGroupResource;
import org.flowable.rest.service.api.identity.MembershipRequest;
import org.flowable.rest.service.api.identity.MembershipResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Groups"}, description="Manage Groups", authorizations={@Authorization(value="basicAuth")})
public class GroupMembershipCollectionResource
extends BaseGroupResource {
    @ApiOperation(value="Add a member to a group", tags={"Groups"})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the group was found and the member has been added."), @ApiResponse(code=400, message="Indicates the userId was not included in the request body."), @ApiResponse(code=404, message="Indicates the requested group was not found."), @ApiResponse(code=409, message="Indicates the requested user is already a member of the group.")})
    @PostMapping(value={"/identity/groups/{groupId}/members"}, produces={"application/json"})
    public MembershipResponse createMembership(@ApiParam(name="groupId") @PathVariable String groupId, @RequestBody MembershipRequest memberShip, HttpServletRequest request, HttpServletResponse response) {
        Group group = this.getGroupFromRequest(groupId);
        if (memberShip.getUserId() == null) {
            throw new FlowableIllegalArgumentException("UserId cannot be null.");
        }
        if (this.identityService.createUserQuery().memberOfGroup(group.getId()).userId(memberShip.getUserId()).count() > 0L) {
            throw new FlowableConflictException("User '" + memberShip.getUserId() + "' is already part of group '" + group.getId() + "'.");
        }
        this.identityService.createMembership(memberShip.getUserId(), group.getId());
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createMembershipResponse(memberShip.getUserId(), group.getId());
    }
}

