/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.IdentityService;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.idm.api.User;
import org.flowable.rest.exception.FlowableConflictException;
import org.flowable.rest.service.api.RestResponseFactory;
import org.flowable.rest.service.api.identity.BaseUserResource;
import org.flowable.rest.service.api.identity.UserInfoRequest;
import org.flowable.rest.service.api.identity.UserInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Users"}, description="Manage Users", authorizations={@Authorization(value="basicAuth")})
public class UserInfoCollectionResource
extends BaseUserResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;

    @ApiOperation(value="List user\u2019s info", tags={"Users"}, nickname="listUserInfo")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the user was found and list of info (key and url) is returned."), @ApiResponse(code=404, message="Indicates the requested user was not found.")})
    @GetMapping(value={"/identity/users/{userId}/info"}, produces={"application/json"})
    public List<UserInfoResponse> getUserInfo(@ApiParam(name="userId") @PathVariable String userId, HttpServletRequest request) {
        User user = this.getUserFromRequest(userId);
        return this.restResponseFactory.createUserInfoKeysResponse(this.identityService.getUserInfoKeys(user.getId()), user.getId());
    }

    @ApiOperation(value="Create a new user\u2019s info entry", tags={"Users"}, nickname="createUserInfo")
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the user was found and the info has been created."), @ApiResponse(code=400, message="Indicates the key or value was missing from the request body. Status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the requested user was not found."), @ApiResponse(code=409, message="Indicates there is already an info-entry with the given key for the user, update the resource instance (PUT).")})
    @PostMapping(value={"/identity/users/{userId}/info"}, produces={"application/json"})
    public UserInfoResponse setUserInfo(@ApiParam(name="userId") @PathVariable String userId, @RequestBody UserInfoRequest userRequest, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        if (userRequest.getKey() == null) {
            throw new FlowableIllegalArgumentException("The key cannot be null.");
        }
        if (userRequest.getValue() == null) {
            throw new FlowableIllegalArgumentException("The value cannot be null.");
        }
        String existingValue = this.identityService.getUserInfo(user.getId(), userRequest.getKey());
        if (existingValue != null) {
            throw new FlowableConflictException("User info with key '" + userRequest.getKey() + "' already exists for this user.");
        }
        this.identityService.setUserInfo(user.getId(), userRequest.getKey(), userRequest.getValue());
        response.setStatus(HttpStatus.CREATED.value());
        return this.restResponseFactory.createUserInfoResponse(userRequest.getKey(), userRequest.getValue(), user.getId());
    }
}

