/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.ManagementService;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.job.api.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Jobs"}, description="Manage Jobs", authorizations={@Authorization(value="basicAuth")})
public class JobExceptionStacktraceResource {
    @Autowired
    protected ManagementService managementService;

    @ApiOperation(value="Get the exception stacktrace for a job", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested job was not found and the stacktrace has been returned. The response contains the raw stacktrace and always has a Content-type of text/plain."), @ApiResponse(code=404, message="Indicates the requested job was not found or the job doesn\u2019t have an exception stacktrace. Status-description contains additional information about the error.")})
    @GetMapping(value={"/management/jobs/{jobId}/exception-stacktrace"})
    public String getJobStacktrace(@ApiParam(name="jobId") @PathVariable String jobId, HttpServletResponse response) {
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        String stackTrace = this.managementService.getJobExceptionStacktrace(job.getId());
        if (stackTrace == null) {
            throw new FlowableObjectNotFoundException("Job with id '" + job.getId() + "' doesn't have an exception stacktrace.", String.class);
        }
        response.setContentType("text/plain");
        return stackTrace;
    }

    @ApiOperation(value="Get the exception stacktrace for a timer job", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested job was not found and the stacktrace has been returned. The response contains the raw stacktrace and always has a Content-type of text/plain."), @ApiResponse(code=404, message="Indicates the requested job was not found or the job doesn\u2019t have an exception stacktrace. Status-description contains additional information about the error.")})
    @GetMapping(value={"/management/timer-jobs/{jobId}/exception-stacktrace"})
    public String getTimerJobStacktrace(@ApiParam(name="jobId") @PathVariable String jobId, HttpServletResponse response) {
        Job job = (Job)this.managementService.createTimerJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        String stackTrace = this.managementService.getTimerJobExceptionStacktrace(job.getId());
        if (stackTrace == null) {
            throw new FlowableObjectNotFoundException("Timer job with id '" + job.getId() + "' doesn't have an exception stacktrace.", String.class);
        }
        response.setContentType("text/plain");
        return stackTrace;
    }

    @ApiOperation(value="Get the exception stacktrace for a suspended job", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested job was not found and the stacktrace has been returned. The response contains the raw stacktrace and always has a Content-type of text/plain."), @ApiResponse(code=404, message="Indicates the requested job was not found or the job doesn\u2019t have an exception stacktrace. Status-description contains additional information about the error.")})
    @GetMapping(value={"/management/suspended-jobs/{jobId}/exception-stacktrace"})
    public String getSuspendedJobStacktrace(@ApiParam(name="jobId") @PathVariable String jobId, HttpServletResponse response) {
        Job job = (Job)this.managementService.createSuspendedJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        String stackTrace = this.managementService.getSuspendedJobExceptionStacktrace(job.getId());
        if (stackTrace == null) {
            throw new FlowableObjectNotFoundException("Suspended job with id '" + job.getId() + "' doesn't have an exception stacktrace.", String.class);
        }
        response.setContentType("text/plain");
        return stackTrace;
    }

    @ApiOperation(value="Get the exception stacktrace for a deadletter job", tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the requested job was not found and the stacktrace has been returned. The response contains the raw stacktrace and always has a Content-type of text/plain."), @ApiResponse(code=404, message="Indicates the requested job was not found or the job doesn\u2019t have an exception stacktrace. Status-description contains additional information about the error.")})
    @GetMapping(value={"/management/deadletter-jobs/{jobId}/exception-stacktrace"})
    public String getDeadLetterJobStacktrace(@ApiParam(name="jobId") @PathVariable String jobId, HttpServletResponse response) {
        Job job = (Job)this.managementService.createDeadLetterJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        String stackTrace = this.managementService.getDeadLetterJobExceptionStacktrace(job.getId());
        if (stackTrace == null) {
            throw new FlowableObjectNotFoundException("Suspended job with id '" + job.getId() + "' doesn't have an exception stacktrace.", String.class);
        }
        response.setContentType("text/plain");
        return stackTrace;
    }
}

